/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.resin;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.ServletContainerCapability;
import org.codehaus.cargo.container.internal.resin.ResinRun;
import org.codehaus.cargo.container.internal.resin.ResinUtil;
import org.codehaus.cargo.container.spi.AbstractContainer;
import org.codehaus.cargo.container.spi.ContainerConfiguration;

public abstract class AbstractResinContainer
extends AbstractContainer
implements Container {
    private String version;
    private ContainerCapability capability = new ServletContainerCapability();

    public ContainerCapability getCapability() {
        return this.capability;
    }

    public final void doStart(Java java) throws Exception {
        ContainerConfiguration resinConfiguration = (ContainerConfiguration)this.getConfiguration();
        this.verify(resinConfiguration);
        resinConfiguration.configure();
        java.addSysproperty(this.getAntUtils().createSysProperty("resin.home", this.getConfiguration().getDir()));
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(this.getResourceUtils().getResourceLocation("/" + ResinRun.class.getName().replace('.', '/') + ".class"));
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.getHomeDir());
        fileSet.createInclude().setName("lib/*.jar");
        classpath.addFileset(fileSet);
        java.setClassname(ResinRun.class.getName());
        java.createArg().setValue("-start");
        java.createArg().setValue("-conf");
        java.createArg().setFile(new File(this.getConfiguration().getDir(), "resin.conf"));
        this.startUpAdditions(java, classpath);
        AntContainerExecutorThread resinRunner = new AntContainerExecutorThread(java);
        resinRunner.start();
    }

    public final void doStop(Java java) throws Exception {
        java.setFork(true);
        java.addSysproperty(this.getAntUtils().createSysProperty("resin.home", this.getConfiguration().getDir()));
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(this.getResourceUtils().getResourceLocation("/" + ResinRun.class.getName().replace('.', '/') + ".class"));
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.getHomeDir());
        fileSet.createInclude().setName("lib/*.jar");
        classpath.addFileset(fileSet);
        java.setClassname(ResinRun.class.getName());
        java.createArg().setValue("-stop");
        AntContainerExecutorThread resinRunner = new AntContainerExecutorThread(java);
        resinRunner.start();
    }

    protected abstract void startUpAdditions(Java var1, Path var2) throws FileNotFoundException;

    private void verify(ContainerConfiguration configuration) {
        this.verifyHomeDir();
        configuration.verifyProperties();
    }

    protected String getVersion(String defaultVersion) {
        String version = this.version;
        if (version == null) {
            try {
                URLClassLoader classloader = new URLClassLoader(new URL[]{new File(this.getHomeDir(), "/lib/resin.jar").toURL()});
                version = new ResinUtil().getResinVersion(classloader);
                this.getMonitor().info("Found Resin version [" + version + "]", this.getClass().getName());
            }
            catch (Exception e) {
                this.getMonitor().debug("Failed to get Resin version, Error = [" + e.getMessage() + "]. Using generic version [" + defaultVersion + "]", this.getClass().getName());
                version = defaultVersion;
            }
        }
        this.version = version;
        return version;
    }
}

