/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.codehaus.cargo.module.JarArchive;

public class DefaultJarArchive
implements JarArchive {
    private byte[] content;

    public DefaultJarArchive(File theFile) throws IOException {
        this(new FileInputStream(theFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultJarArchive(InputStream theInputStream) throws IOException {
        try {
            int bytesRead;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((bytesRead = theInputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            this.content = baos.toByteArray();
        }
        finally {
            if (theInputStream != null) {
                theInputStream.close();
            }
        }
    }

    public boolean containsClass(String theClassName) throws IOException {
        String resourceName = theClassName.replace('.', '/') + ".class";
        return this.getResource(resourceName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String findResource(String theName) throws IOException {
        JarInputStream in = null;
        try {
            ZipEntry entry;
            in = new JarInputStream(this.getContentAsStream());
            while ((entry = in.getNextEntry()) != null) {
                String entryName = entry.getName();
                int lastSlashIndex = entryName.lastIndexOf(47);
                if (lastSlashIndex >= 0) {
                    entryName = entryName.substring(lastSlashIndex + 1);
                }
                if (!entryName.equals(theName)) continue;
                String string = entry.getName();
                return string;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InputStream getResource(String thePath) throws IOException {
        JarInputStream in = null;
        try {
            ZipEntry zipEntry;
            in = this.getContentAsStream();
            while ((zipEntry = in.getNextEntry()) != null) {
                int bytesRead;
                if (!thePath.equals(zipEntry.getName())) continue;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                while ((bytesRead = in.read(bytes)) != -1) {
                    buffer.write(bytes, 0, bytesRead);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer.toByteArray());
                return byteArrayInputStream;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getResources(String thePath) throws IOException {
        ArrayList<String> resources = new ArrayList<String>();
        JarInputStream in = null;
        try {
            ZipEntry zipEntry;
            in = this.getContentAsStream();
            while ((zipEntry = in.getNextEntry()) != null) {
                if (!zipEntry.getName().startsWith(thePath) || zipEntry.getName().equals(thePath)) continue;
                resources.add(zipEntry.getName());
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return resources;
    }

    protected final JarInputStream getContentAsStream() throws IOException {
        return new JarInputStream(new ByteArrayInputStream(this.content));
    }
}

