package jp.haw.grain.transform;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.transformer.Body2View;
import junit.framework.TestCase;

/**
 * @author nakajo
 */
public class Body2ViewTest extends TestCase {

	/**
	 * body^Oviewɕϊform̎qvfƂĒǉeXg
	 *
	 */
	public void testSimpleTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "body", null);
		
		Body2View body2view = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node view = nodes.item(0);
				assertEquals("transformed element check", view.getNodeName(), "view");
				NamedNodeMap attrs = view.getAttributes();
				Node title = attrs.getNamedItem("title");
				assertTrue("title is empty check", title == null);
			}
		};

		body2view.apply(simpleDoc.getDocumentElement(), mockOperation);
	}
	
	/**
	 * titleviewɕϊeXg
	 *
	 */
	public void testHasTitleTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "head", null);
		Element title = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "title");
		Text titleText = simpleDoc.createTextNode("eXg");
		Element body = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "body");
		simpleDoc.getDocumentElement().appendChild(title);
		title.appendChild(titleText);
		simpleDoc.getDocumentElement().appendChild(body);
		

		Body2View body2view = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node view = nodes.item(0);
				assertEquals("transformed element check", view.getNodeName(), "view");
				NamedNodeMap attrs = view.getAttributes();
				Node title = attrs.getNamedItem("title");
				assertTrue("title is not empty check", title != null);
				assertTrue("title has same text", title.getNodeValue().equals("eXg"));
			}
		};

		body2view.apply(body, mockOperation);
	}
	
	/**
	 * XHTML namespaceȂ^O͕ϊȂ
	 *
	 */
	public void testNotXHTMLTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument("http://grain.jp/test/", "body", null);

		Body2View body2view = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer is null check", this.transformer, null);
				return super.createChildNodeOperation();
			}

		};
		

		body2view.apply(simpleDoc.getDocumentElement(), mockOperation);
		mockOperation.createChildNodeOperation();
	}
	
	class MockTransformer extends Body2View {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, boolean targetResult) {
			super(builder);
			this.targetResult = targetResult;
		}
		
		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}
}
