package jp.haw.grain.transform;

import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.transformer.ModelChildCopy;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/**
 * @author nakajo
 */
public class ModelChildCopyText extends TestCase {
	
	/**
	 * modelvfgudmodelvfɃRs[B
	 *
	 */
	public void testSimpleTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "model", null);
		Element model = simpleDoc.getDocumentElement();
		
		ModelChildCopy modelCopy = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue("has child check", df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("child length check", nodes.getLength(), 1);
				Node node = nodes.item(0);
				assertEquals("node name check", node.getNodeName(), "model");
				assertEquals("namespaceURI is gud check", node.getNamespaceURI(), GudBuilder.GUD_NS);
				assertTrue("current is null check", t.getCurrentElement() != null);
			}
		};

		modelCopy.apply(model, mockOperation);
	}

	/**
	 * modelvfgudmodelvfɃRs[B
	 * Rs[B
	 *
	 */
	public void testAttrsCopy() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "model", null);
		Element model = simpleDoc.getDocumentElement();
		model.setAttribute("ev:event", "DOMActivate");
		model.setAttribute("id", "hog1");
		model.setAttribute("padding", "2px");
		
		ModelChildCopy modelCopy = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue("has child check", df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("child length check", nodes.getLength(), 1);
				Node node = nodes.item(0);
				assertEquals("node name check", node.getNodeName(), "model");
				assertEquals("namespaceURI is gud check", node.getNamespaceURI(), GudBuilder.GUD_NS);
				assertTrue("current is null check", t.getCurrentElement() != null);
				
				NamedNodeMap attrs = node.getAttributes();
				assertEquals("attrs length check", attrs.getLength(), 3);
				Node event = attrs.getNamedItem("ev:event");
				Node id = attrs.getNamedItem("id");
				Node padding = attrs.getNamedItem("padding");
				
				assertTrue("event not null check", event != null);
				assertTrue("id not null check", id != null);
				assertTrue("padding not null check", padding != null);

				assertEquals("event same value check", event.getNodeValue(), "DOMActivate");
				assertEquals("id same value check", id.getNodeValue(), "hog1");
				assertEquals("padding same value check", padding.getNodeValue(), "2px");
			}
		};

		modelCopy.apply(model, mockOperation);
	}

	/**
	 * modelcɎvfRs[B
	 *
	 */
	public void testDeepCopy() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "model", null);
		Element model = simpleDoc.getDocumentElement();
		Element person = simpleDoc.createElementNS("http://grain.jp/my", "my:person");
		Element name = simpleDoc.createElementNS("http://grain.jp/my/person", "person:name");
		Element age = simpleDoc.createElementNS("http://grain.jp/my/person", "person:age");
		Text nametext = simpleDoc.createTextNode("Ȃ");
		
		model.appendChild(person);
		person.appendChild(name);
		person.appendChild(age);
		name.appendChild(nametext);
		
		
		ModelChildCopy modelCopy = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue("has child check", df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("child length check", nodes.getLength(), 1);
				Node node = nodes.item(0);
				assertTrue("current is null check", t.getCurrentElement() != null);

				assertEquals("same localname check", node.getLocalName(), "person");
				assertEquals("same namespaceURI check", node.getNamespaceURI(), "http://grain.jp/my");
				assertEquals("same prefix check", node.getPrefix(), "my");
				
			}
		};
		modelCopy.apply(person, mockOperation);
		
		mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
					/* ( Javadoc)
					 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
					 */
					public void operation(AbstractTransformer t) {
						DocumentFragment df = t.transform();
						assertTrue("has child check", df.hasChildNodes());
						NodeList nodes = df.getChildNodes();
						assertEquals("child length check", nodes.getLength(), 1);
						Node node = nodes.item(0);
						assertTrue("current is null check", t.getCurrentElement() != null);

						assertEquals("same localname check", node.getLocalName(), "name");
						assertEquals("same namespaceURI check", node.getNamespaceURI(), "http://grain.jp/my/person");
						assertEquals("same prefix check", node.getPrefix(), "person");
				
					}
				};
		modelCopy.apply(name, mockOperation);
		
		mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
					/* ( Javadoc)
					 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
					 */
					public void operation(AbstractTransformer t) {
						DocumentFragment df = t.transform();
						assertTrue("has child check", df.hasChildNodes());
						NodeList nodes = df.getChildNodes();
						assertEquals("child length check", nodes.getLength(), 1);
						Node node = nodes.item(0);
						assertTrue("current is null check", t.getCurrentElement() != null);
						
						assertEquals("same localname check", node.getLocalName(), "age");
						assertEquals("same namespaceURI check", node.getNamespaceURI(), "http://grain.jp/my/person");
						assertEquals("same prefix check", node.getPrefix(), "person");
					}
				};
		modelCopy.apply(age, mockOperation);

		mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
					/* ( Javadoc)
					 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
					 */
					public void operation(AbstractTransformer t) {
						DocumentFragment df = t.transform();
						assertTrue("has child check", df.hasChildNodes());
						NodeList nodes = df.getChildNodes();
						assertEquals("child length check", nodes.getLength(), 1);
						Node node = nodes.item(0);
						assertTrue("current is null check", t.getCurrentElement() == null);
						
						assertEquals("same localname check", node.getLocalName(), null);
						assertEquals("same text check", node.getNodeValue(), "Ȃ");
					}
				};
		modelCopy.apply(nametext, mockOperation);
	}


	/**
	 * modelȂ̂ŕϊΏۂɂȂȂ
	 *
	 */
	public void testNotModelTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "instance", null);
		Element xforms = simpleDoc.getDocumentElement();

		ModelChildCopy modelCopy = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		modelCopy.apply(xforms, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	/**
	 * NSXForms̗vf̏ꍇgudNSɂȂB
	 *
	 */
	public void testXformsElementCopy() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "model", null);
		Element model = simpleDoc.getDocumentElement();
		Element submission = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "submission");
		
		model.appendChild(submission);
		
		ModelChildCopy modelCopy = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue("has child check", df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("child length check", nodes.getLength(), 1);
				Node node = nodes.item(0);
				assertEquals("node name check", node.getNodeName(), "submission");
				assertEquals("namespaceURI is gud check", node.getNamespaceURI(), GudBuilder.GUD_NS);
				assertTrue("current is null check", t.getCurrentElement() != null);
				
			}
		};

		modelCopy.apply(submission, mockOperation);
	}

	/**
	 * emodelȂ̂ŕϊΏۂɂȂȂB
	 *
	 */
	public void testNotModelChild() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "instance", null);
		Element xforms = simpleDoc.getDocumentElement();
		Element person = simpleDoc.createElementNS("http://grain.jp/my", "my:person");

		xforms.appendChild(person);
		
		ModelChildCopy modelCopy = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		modelCopy.apply(person, mockOperation);
		mockOperation.createChildNodeOperation();
	}
	
	class MockTransformer extends ModelChildCopy {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, boolean targetResult) {
			super(builder);
			this.targetResult = targetResult;
		}
		
		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}

}
