package jp.haw.grain.divide;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.apache.log4j.Logger;

/**
 * Mp̃tH_[NXłB
 * @author nakajo
 */
public class WriteFolder implements DataFolder, Serializable {
	private static final Logger log = Logger.getLogger(WriteFolder.class);
	
	protected int mode;
	protected String sessionId;
	protected String contentType;
	protected long createTime;
	protected long survivalTime;
	protected DividedData[] dataList;
	
	public static WriteFolder createFolder(String sessionId, byte[] data, int bufferSize) throws IOException {
		BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(data));
		List datas = new ArrayList();
		byte[] buf = new byte[1];
		int no = 1;
		ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
		while(in.read(buf) != -1) {
			dataOut.write(buf);
			if(dataOut.toByteArray().length == bufferSize) {
				datas.add(new DividedData(dataOut.toByteArray(), no));
				no++;
				dataOut = new ByteArrayOutputStream();
			}
		}
		
		if(dataOut.toByteArray().length > 0) {
			datas.add(new DividedData(dataOut.toByteArray(), no));
		}
		
		return new WriteFolder((DividedData[])datas.toArray(new DividedData[datas.size()]), sessionId);
	}
	
	private WriteFolder(DividedData[] dataList, String sessionId) {
		this.sessionId = sessionId;
		this.dataList = dataList;
		this.mode = DataFolder.MODE_WRITE;
		this.createTime = Calendar.getInstance().getTimeInMillis();
		this.survivalTime = 60 * 30 * 1000; //ftHg30
	}
	
	/**
	 * no̕f[^擾܂BAnõf[^݂ȂꍇnullԂ܂B
	 */
	public DividedData getDataAt(int no) {
		log.debug("no="+no);
		for(int i=0; i<dataList.length; i++) {
			if(dataList[i].getNo() == no) return dataList[i]; 
		}
		
		return null;
	}

	public DividedData[] getDataList() {
		return this.dataList;
	}

	public int getMaxCount() {
		return this.dataList.length;
	}

	public int getMode() {
		return this.mode;
	}

	public String getSessionId() {
		return this.sessionId;
	}

	/**
	 * ̃f[^tH_[܂Ă邩ǂԂ܂B
	 */
	public boolean isSurvival() {
		long nowTime = Calendar.getInstance().getTimeInMillis();
		return nowTime <= (this.createTime + this.survivalTime);
	}

	/**
	 * ̃tH_Ă̎~bŎw肵܂B
	 * @param l
	 */
	public void setSurvivalTime(long l) {
		survivalTime = l;
	}

	/**
	 * @return
	 */
	public long getSurvivalTime() {
		return survivalTime;
	}

	/* ( Javadoc)
	 * @see jp.haw.grain.divide.DataFolder#getContentType()
	 */
	public String getContentType() {
		return this.contentType;
	}
	
	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

}
