package jp.haw.grain.transform;

import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.transformer.Item2Item;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


/**
 * @author nakajo
 */
public class Item2ItemTest extends TestCase {

	/**
	 * item^OϊĂ݂B
	 * labelvalueȂ̂ŕϊʂ͋
	 *
	 */
	public void testSimpleTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "item", null);
		Element item = simpleDoc.getDocumentElement();
		
		Item2Item item2item = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertNull("documentFragment is null", df);
				assertNull("current is null", t.getCurrentElement());
			}
		};

		item2item.apply(item, mockOperation);
	}

	/**
	 * labelitem^Oϊ
	 *
	 */
	public void testHasLabelTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "item", null);
		Element item = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		
		label.setTextContent("ACXN[");
		
		item.appendChild(label);
		
		Item2Item item2item = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				assertNull("current is null", t.getCurrentElement());
				
				Node node = nodes.item(0);
				assertEquals("name check", node.getNodeName(), "item");
				NodeList children = node.getChildNodes();
				assertEquals("item child length check", children.getLength(), 1);
				Node name = children.item(0);

				assertEquals("name t check", name.getNodeName(), "name");
				assertEquals("name same text check", name.getTextContent(), "ACXN[");
			}
		};

		item2item.apply(item, mockOperation);
	}
	/**
	 * valueitem^Oϊ
	 *
	 */
	public void testHasValuenTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "item", null);
		Element item = simpleDoc.getDocumentElement();
		Element value = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "value");
		
		value.setTextContent("100~");
		
		item.appendChild(value);
		
		Item2Item item2item = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				assertNull("current is null", t.getCurrentElement());
				
				Node node = nodes.item(0);
				assertEquals("name check", node.getNodeName(), "item");
				NodeList children = node.getChildNodes();
				assertEquals("item child length check", children.getLength(), 1);
				Node value = children.item(0);

				assertEquals("name t check", value.getNodeName(), "value");
				assertEquals("value same text check", value.getTextContent(), "100~");
			}
		};

		item2item.apply(item, mockOperation);
	}
	
	/**
	 * label, valueitem^Oϊ
	 *
	 */
	public void testHasChildrenTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "item", null);
		Element item = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		Element value = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "value");
		
		label.setTextContent("ACXN[");
		value.setTextContent("100~");
		
		item.appendChild(label);
		item.appendChild(value);
		
		Item2Item item2item = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				assertNull("current is null", t.getCurrentElement());
				
				Node node = nodes.item(0);
				assertEquals("name check", node.getNodeName(), "item");
				NodeList children = node.getChildNodes();
				assertEquals("item child length check", children.getLength(), 2);
				Node name = null;
				Node value = null;
				for(int i=0; i<children.getLength(); i++) {
					Node child = children.item(i);
					if(child.getNodeName().equals("name")) name = child;
					if(child.getNodeName().equals("value")) value = child;
				}
				
				assertEquals("name same text check", name.getTextContent(), "ACXN[");
				assertEquals("value same text check", value.getTextContent(), "100~");
			}
		};

		item2item.apply(item, mockOperation);
	}

	/**
	 * labe2vfϊBŏɌꂽlabel݂̂ΏۂƂȂB
	 *
	 */
	public void testHasOverChildrenTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "item", null);
		Element item = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		Element label2 = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		Element value = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "value");
		
		label.setTextContent("ACXN[");
		label2.setTextContent("C`S");
		value.setTextContent("100~");
		
		item.appendChild(label);
		item.appendChild(label2);
		item.appendChild(value);
		
		Item2Item item2item = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				assertNull("current is null", t.getCurrentElement());
				
				Node node = nodes.item(0);
				assertEquals("name check", node.getNodeName(), "item");
				NodeList children = node.getChildNodes();
				assertEquals("item child length check", children.getLength(), 2);
				Node name = null;
				Node value = null;
				for(int i=0; i<children.getLength(); i++) {
					Node child = children.item(i);
					if(child.getNodeName().equals("name")) name = child;
					if(child.getNodeName().equals("value")) value = child;
				}
				
				assertEquals("name same text check", name.getTextContent(), "ACXN[");
				assertEquals("value same text check", value.getTextContent(), "100~");
			}
		};

		item2item.apply(item, mockOperation);
	}
	/**
	 * labevalue2vfϊBŏɌꂽlabel݂̂ΏۂƂȂB
	 *
	 */
	public void testHasOverChildrenTag2() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "item", null);
		Element item = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		Element label2 = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		Element value = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "value");
		Element value2 = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "value");
		
		label.setTextContent("ACXN[");
		label2.setTextContent("C`S");
		value.setTextContent("100~");
		value2.setTextContent("-10~");
		
		item.appendChild(label);
		item.appendChild(label2);
		item.appendChild(value);
		item.appendChild(value2);
		
		Item2Item item2item = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				assertNull("current is null", t.getCurrentElement());
				
				Node node = nodes.item(0);
				assertEquals("name check", node.getNodeName(), "item");
				NodeList children = node.getChildNodes();
				assertEquals("item child length check", children.getLength(), 2);
				Node name = null;
				Node value = null;
				for(int i=0; i<children.getLength(); i++) {
					Node child = children.item(i);
					if(child.getNodeName().equals("name")) name = child;
					if(child.getNodeName().equals("value")) value = child;
				}
				
				assertEquals("name same text check", name.getTextContent(), "ACXN[");
				assertEquals("value same text check", value.getTextContent(), "100~");
			}
		};

		item2item.apply(item, mockOperation);
	}
	/**
	 * label, valueitem^Oϊ
	 * valuetextm[hĂȂ
	 *
	 */
	public void testValueNotHasTextTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "item", null);
		Element item = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		Element value = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "value");
		
		label.setTextContent("ACXN[");
		
		item.appendChild(label);
		item.appendChild(value);
		
		Item2Item item2item = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				assertNull("current is null", t.getCurrentElement());
				
				Node node = nodes.item(0);
				assertEquals("name check", node.getNodeName(), "item");
				NodeList children = node.getChildNodes();
				assertEquals("item child length check", children.getLength(), 1);
				Node name = children.item(0);

				assertEquals("name t check", name.getNodeName(), "name");
				assertEquals("name same text check", name.getTextContent(), "ACXN[");
			}
		};

		item2item.apply(item, mockOperation);
	}

	/**
	 * label, valueitem^Oϊ
	 * labeltextm[hĂȂ
	 *
	 */
	public void testLabelNotHasTextTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "item", null);
		Element item = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		Element value = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "value");
		
		value.setTextContent("100~");
		
		item.appendChild(label);
		item.appendChild(value);
		
		Item2Item item2item = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				assertNull("current is null", t.getCurrentElement());
				
				Node node = nodes.item(0);
				assertEquals("name check", node.getNodeName(), "item");
				NodeList children = node.getChildNodes();
				assertEquals("item child length check", children.getLength(), 1);
				Node value = children.item(0);

				assertEquals("name t check", value.getNodeName(), "value");
				assertEquals("name same text check", value.getTextContent(), "100~");
			}
		};

		item2item.apply(item, mockOperation);
	}

	/**
	 * label, value^Oϊ
	 * localnameitemȂ
	 *
	 */
	public void testNotItemTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "input", null);
		Element item = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		Element value = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "value");
		
		label.setTextContent("ACXN[");
		value.setTextContent("100~");
		
		item.appendChild(label);
		item.appendChild(value);
		
		Item2Item item2item = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		item2item.apply(item, mockOperation);
		mockOperation.createChildNodeOperation();
	}
	class MockTransformer extends Item2Item {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, boolean targetResult) {
			super(builder);
			this.targetResult = targetResult;
		}
		
		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}
}
