package jp.haw.grain.transform;

import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.transformer.Textarea2Textbox;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author nakajo
 */
public class Textarea2TextboxTest extends TestCase {

	/**
	 * XformstextareavftextboxvfɕϊB
	 * multiline=trueIɕtB
	 *
	 */
	public void testSimpleTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "textarea", null);
		Element textbox = simpleDoc.getDocumentElement();

		Textarea2Textbox tea2teb = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);

				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "textbox");
				
				//secret̃`FbN
				NamedNodeMap attrs = node.getAttributes();
				Node secretAttr = attrs.getNamedItem("multiline");
				assertEquals("secret attr value check", secretAttr.getNodeValue(), "true");
				assertTrue("current is null check", t.getCurrentElement() != null);
			}
		};

		tea2teb.apply(textbox, mockOperation);
	}

	/**
	 * XformstextareavftextboxvfɕϊB
	 * multiline=trueIɕtB
	 * qvflabelvfZvfinlineƂēWJB
	 *
	 */
	public void testLabel2inline() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "textarea", null);
		Element textarea = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		label.setTextContent("pX[hF");
		textarea.appendChild(label);
		
		Textarea2Textbox tea2teb = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 2);

				Node inline = nodes.item(0);
				Node textbox = nodes.item(1);
				assertEquals("name check", inline.getLocalName(), "inline");
				assertEquals("inline has same text check", inline.getTextContent(), "pX[hF");

				assertEquals("name check", textbox.getLocalName(), "textbox");
				NamedNodeMap attrs = textbox.getAttributes();
				Node secretAttr = attrs.getNamedItem("multiline");
				assertEquals("secret attr value check", secretAttr.getNodeValue(), "true");
				
				assertTrue("current is null check", t.getCurrentElement() != null);
			}
		};

		tea2teb.apply(textarea, mockOperation);
	}

	/**
	 * eLXgm[hۂlabelłΓWJȂB
	 *
	 */
	public void testEmptyLabel() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "textarea", null);
		Element textarea = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		
		textarea.appendChild(label);

		Textarea2Textbox tea2teb = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);

				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "textbox");
				
				//secret̃`FbN
				NamedNodeMap attrs = node.getAttributes();
				Node secretAttr = attrs.getNamedItem("multiline");
				assertEquals("secret attr value check", secretAttr.getNodeValue(), "true");
				assertTrue("current is null check", t.getCurrentElement() != null);
			}
		};

		tea2teb.apply(textarea, mockOperation);
	}
	
	/**
	 * localnamesecretȂ̂ŕϊΏۂɂȂȂ
	 *
	 */
	public void testNotXFormsTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "input", null);
		Element input = simpleDoc.getDocumentElement();

		Textarea2Textbox tea2teb = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		tea2teb.apply(input, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	/**
	 * NSXFormsȂ̂ŕϊΏۂɂȂȂ
	 *
	 */
	public void testWrongNSTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "textarea", null);
		Element input = simpleDoc.getDocumentElement();

		Textarea2Textbox tea2teb = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		tea2teb.apply(input, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	class MockTransformer extends Textarea2Textbox {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, boolean targetResult) {
			super(builder);
			this.targetResult = targetResult;
		}

		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}
}
