/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/21 22:53:29
 * 
 */
package jp.grain.spike;

import jp.grain.spike.event.Event;
import jp.grain.spike.xpath.XPathExpr;

/**
 * TODO DefaultElement
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class DefaultElement extends Element {

    protected XPathExpr _binding;

    /**
     * @param name
     */
    public DefaultElement(String name) {
        super(name);
    }

    public DefaultElement(String name, String prefix, String namespace) {
        super(name, prefix, namespace);
    }
    
    /* (non-Javadoc)
     * @see jp.grain.spike.Node#preProcess(jp.grain.spike.Node)
     */
    public void preProcess(Node parent) {
        if (parent instanceof Element) {
        	Element elm = (Element)parent;
        	((Element)parent).addChild(this);
        } else if (parent instanceof Document) {
            ((Document)parent).setRootElement(this);
        }
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Node#postProcess(jp.grain.spike.Node)
     */
    public void postProcess(Node parent) {
        // nothing to do
    }
    
    public Node clone() {
        Element elem = new DefaultElement(_name, _prefix, _namespace);
        if (_attributes != null) {
            for (int i = 0; i < _attributes.size(); ++i) {
                Attribute src = (Attribute)_attributes.elementAt(i);
                elem.addAttribute(src._name, src._prefix, src._namespace, src._value);
            }
        }
        for (int i = 0; i < getChildCount(); ++i) {
            Object child = getChild(i);
            if (child instanceof Node) {
                elem.addChild(((Node)child).clone());
            } else if (child instanceof String) {
                elem.setText((String)child);
            }
        }
        return elem;
    }

    public void dispatchEvent(Event event) {
        System.out.println("event name=" + event.getType());
        for (int i = 0; i < getChildCount(); ++i) {
            DefaultElement elem = (DefaultElement)getChildElement(i);
            if (elem == null) continue;
            String ev = elem.getAttribute("event", Event.NAME_SPACE);
            System.out.println("child name=" + elem.getName() + ",ev=" + ev);
            if (ev != null && event.getType().equals(ev)) {
                elem.handleEvent();
            }
        }
    }
    
    /**
     * 
     */
    public void handleEvent() {
    }

    public boolean isBindingElement() {
        return false;
    }
    
    public Node getBindingNode() {
        if (_binding == null) return null;
        return _binding.getNode();
    }
    
    /**
     * @return
     */
    public Node[] getBindingNodeset() {
        if (_binding == null) return null;
        return _binding.getNodeset();
    }

    /**
     * @param _expr
     */
    public void setBindingExpr(XPathExpr binding) {
        _binding = binding;
    }
    
}
