/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/18 14:59:31
 * 
 */
package jp.grain.spike;

import java.util.Vector;

/**
 * TODO Document
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Document extends Node {
    
    Element _root;
    
    public Element getRootElement() {
        return _root;
    }

    public void setRootElement(Element root) {
        _root = root;
        root.setParent(this);
    }
    
	public Vector getElementsByTagName(String tagName) {
		Vector elements = new Vector();
		getElementsByTagName(_root, elements, tagName);
		return elements;
	}
	
	private void getElementsByTagName(Element current, Vector elements, String tagName) {
		if(tagName.equals(current.getName())) elements.addElement(current);
		System.out.println("initRef: serch: nodeName=["+current.getName()+":"+current.getPrefix()+":"+current.getNamespace()+"]");
		for(int i=0; i<current.getChildCount(); i++) {
			if(!(current.getChild(i) instanceof Element)) continue;
			getElementsByTagName((Element)current.getChild(i), elements, tagName);
		}
	}
	
    /* (non-Javadoc)
     * @see jp.grain.spike.Node#preProcess(jp.grain.spike.Node)
     */
    public void preProcess(Node parent) {
        // nothing to do
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Node#postProcess(jp.grain.spike.Node)
     */
    public void postProcess(Node parent) {
        // nothing to do
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Node#getSimpleContent()
     */
    public String getSimpleContent() {
        return Node.EMPTY_STRING;
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Node#setSimpleContent(java.lang.String)
     */
    public void setSimpleContent(String content) {
        // nothing to do
    }
}


