/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/02/10 9:41:51
 * 
 */
package jp.grain.sprout.model;

import jp.grain.spike.DefaultElement;
import jp.grain.spike.event.Event;
import jp.grain.sprout.OperetionListener;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormContext;

/**
 * TODO Submission
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Submission extends DefaultElement implements OperetionListener {
    
    public static final String NAME = "submission"; 

    /**
     * @param name
     */
    public Submission() {
        super(NAME);
    }
    
    public void submit(FormContext ctx) {
        Form doc = null;
        Event ev = new Event("xforms-submit", true, false);
        dispatchEvent(ev);
        if (ev.isPreventDefault()) return;
        SerializeOperation ope = ctx.createSubmissionOperation(this);
        ctx.execute(ope);
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.OperetionObserver#statusChanged(jp.grain.sprout.SerializeOperation)
     */
    public void operationCompleted(SerializeOperation ope) {
            dispatchEvent(new Event("xforms-submit-done", true, false));
    }
    
    /* (non-Javadoc)
     * @see jp.grain.sprout.OperetionListener#operationFailure(jp.grain.sprout.SerializeOperation, java.lang.Exception)
     */
    public void operationFailure(SerializeOperation ope, Exception e) {
        ((Model)getParentElement()).dispatchEvent(new Event("xforms-submit-error", true, false));
    }

    /**
     * @return
     */
    public String getActionUrl() {
        return getAttribute("action");
    }

}
