/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/28 14:15:07
 * 
 */
package jp.grain.sprout.platform.doja;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

import javax.microedition.io.Connection;
import javax.microedition.io.Connector;

import jp.grain.spike.Node;
import jp.grain.sprout.DataHandler;
import jp.grain.sprout.Initializer;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.ValidationList;
import jp.grain.sprout.model.Instance;
import jp.grain.sprout.model.Model;
import jp.grain.sprout.model.Submission;
import jp.grain.sprout.ui.ActionHandler;
import jp.grain.sprout.ui.Block;
import jp.grain.sprout.ui.DrawContext;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormContext;

import com.nttdocomo.device.Camera;
import com.nttdocomo.device.CodeReader;
import com.nttdocomo.system.InterruptedOperationException;
import com.nttdocomo.ui.Canvas;
import com.nttdocomo.ui.Dialog;
import com.nttdocomo.ui.Display;
import com.nttdocomo.ui.Frame;
import com.nttdocomo.ui.Graphics;
import com.nttdocomo.ui.Image;
import com.nttdocomo.ui.ShortTimer;
import com.nttdocomo.ui.TextBox;

/**
 * FormView̎NXl
 * 
 * @version $Id: FormContextImpl.java 245 2006-04-09 12:25:24Z go $
 * @author Go Takahashi
 */
public class FormContextImpl extends Canvas implements FormContext {

    public static final int[] EVENT_MAPPING = new int[] {
        FormContext.ACT_PRESSED, 
        FormContext.ACT_RELEASED
    };
    
    public static final int KEY_REPEAT_TIMER = 0;
    public static final int ACCERALATION_TIMER = 1;
    private static int SCAN_CAMERA_ID = 0;
    
    private Form form;
    private Vector navigativeElements = new Vector();
//    private Inline focused; // TODO remove
    private int vOffset = 0;
    private ShortTimer activeTimer;
    private int pressedKey;
    private int accelaration;
    private String imeText;
    private byte[] cameraData;
    
    protected GrainApp _app;

//    private int _clipX;
//    private int _clipY;
//    private int _clipWidth;
//    private int _clipHeight;

    private Image _floatingImage;
    private int _floatingX;
    private int _floatingY;

    private boolean _renderingRequested = true;
    private boolean _refreshRequested = true;

    private Initializer _initializer;
       
    /**
     * 
     */
    FormContextImpl(GrainApp app) {
        _app = app;
    }
    
    /* (non-Javadoc)
     * @see com.nttdocomo.ui.Frame#paint(com.nttdocomo.ui.Graphics)
     */
    public void paint(Graphics g) {
        if (this.form == null) return;
        g.lock();
        DrawContext dc = new DrawContextImpl(g, 0, - this.vOffset);
        this.form.draw(dc);
        g.unlock(true);
    }
    
    public void init() throws IOException {
        this.form.init(this);
        setSoftLabel(Frame.SOFT_KEY_2, "MENU");
    }
    
    /* (non-Javadoc)
     * @see jp.haw.grain.xforms.FormView#render()
     */
    public void render() {
        if (!_renderingRequested) return;
        _renderingRequested = false;
        Display.setCurrent(this);
        repaint();
    }

    /* (non-Javadoc)
     * @see jp.haw.grain.xforms.FormView#refresh()
     */
    public void refresh() {
        if (!_refreshRequested) return;
        _refreshRequested = false;
        if (this.form == null) return;
        this.form.layout();
    }

    /* (non-Javadoc)
     * @see jp.haw.grain.xforms.FormView#setRootBlock(jp.haw.grain.xforms.Block)
     */
    public void setForm(Form form) {
        if (form != null) {
            form.getRootBlock().setPreferedWidth(this.getWidth());
        }
        this.form = form;
    }

    /* (non-Javadoc)
     * @see jp.haw.grain.xforms.FormView#getRootBlock()
     */
    public Form getForm() {
        return this.form;
    }

//    /* (non-Javadoc)
//     * @see jp.haw.grain.xforms.FormView#addNavigativeElement(jp.haw.grain.xforms.InlineElement)
//     */
//    public void addNavigativeElement(Inline element) {
//        this.navigativeElements.addElement(element);
//    }
//
//    private Inline findNextNavigation() {
//        int next = navigationIndexOf(this.focused, 1);
//        return (next < 0) ? null : (Inline)this.navigativeElements.elementAt(next);
//    }
//
//    private Inline findPreviousNavigation() {
//        int next = navigationIndexOf(this.focused, -1);
//        return (next < 0) ? null : (Inline)this.navigativeElements.elementAt(next);
//    }
//    
//    private int navigationIndexOf(Inline element, int delta) {
//        if (this.navigativeElements == null || this.navigativeElements.size() == 0) return -1;
//        if (this.focused == null) return 0;
//        int index = this.navigativeElements.indexOf(this.focused);
//        int next = index + delta;
//        if (next < 0) {
//            return this.navigativeElements.size() + next;
//        } if (next >= this.navigativeElements.size()) {
//            return next - this.navigativeElements.size();
//        }
//        return next;
//    }
    
    public void processEvent(int type, int param) {
        try {
            this.imeText = null;
            if (type < EVENT_MAPPING.length) {
                int action = EVENT_MAPPING[type];
                int selector = createKeySelector(param);
                form.handleEvent(this, action, selector);
            }
//            ActionHandler handler = form.getFocusedComponent();
//            if (handler.isCaptureEnable()) {
//                processEventByHandler(type, param, handler);
//            }
            if (type == Display.KEY_RELEASED_EVENT) {
                if (this.activeTimer != null) {
                    this.activeTimer.stop();
                    this.activeTimer.dispose();
                    this.activeTimer = null;
                    if (this.accelaration != 0) return;
                }
//                if (param == Display.KEY_DOWN || param == Display.KEY_UP) {
//                    ActionHandler renewed = (param == Display.KEY_DOWN) ? form.nextNavigation() : form.previousNavigation();
//                    if (handler == renewed) return;
//                    handler.handleAction(this, FormContext.ACT_FOCUS_OUT, FormContext.SEL_NONE);
//                    sctollToFocusedElement();
//                    renewed.handleAction(this, FormContext.ACT_FOCUS_IN, FormContext.SEL_NONE);                
//                    render();
//                } else if (param == Display.KEY_LEFT || param == Display.KEY_RIGHT) {
//                    processEventByHandler(type, param, handler);
//                } else if (param == Display.KEY_SELECT) {
//                    boolean repaint = handler.handleAction(this, FormContext.ACT_RELEASED, FormContext.SEL_SELECT);
//                    if (repaint) render();
                if (param == Display.KEY_SOFT2) {
                    _app.openApplicationMenu();
                }
            } else if (type == Display.KEY_PRESSED_EVENT) {
                if (param == Display.KEY_DOWN || param == Display.KEY_UP) {
                    this.pressedKey = param; 
                    this.accelaration = 0;
                    this.activeTimer = ShortTimer.getShortTimer(this, KEY_REPEAT_TIMER, 400, false);
                    this.activeTimer.start();
//                } else if (param == Display.KEY_SELECT){
//                    boolean repaint = handler.handleAction(this, FormContext.ACT_PRESSED, FormContext.SEL_SELECT);
//                    if (repaint) render();
                }
            } else if (type == Display.TIMER_EXPIRED_EVENT) {
                if (param == KEY_REPEAT_TIMER) {
                    if (this.pressedKey == Display.KEY_DOWN) {
                        this.accelaration = 3;
                    } else if (this.pressedKey == Display.KEY_UP) {
                        this.accelaration = -3;
                    }
                    scroll(this.accelaration);
                    requestRender();
                    this.activeTimer.dispose();
                    this.activeTimer = ShortTimer.getShortTimer(this, ACCERALATION_TIMER, 80, true);
                    this.activeTimer.start();
                } else if (param == ACCERALATION_TIMER) {
                    if (Math.abs(this.accelaration) < 30) this.accelaration = this.accelaration * 2;
                    scroll(this.accelaration);
                    requestRender();
                }
            }
//            if (this.imeText != null) {
//                processIMEEvent(IME_COMMITTED, this.imeText);
//            }
            refresh();
            render();
        } catch (RuntimeException e) {
            e.printStackTrace();
            _app.showMessage(e.getMessage());
        }
    }

    private void processEventByHandler(int type, int param, ActionHandler handler) {
        if (type < EVENT_MAPPING.length) {
            int action = EVENT_MAPPING[type];
            int selector = createKeySelector(param);
            final boolean needsRender = handler.handleAction(this, EVENT_MAPPING[type], selector);
            if (needsRender) render();
        }
    }

    private int createKeySelector(int param) {
        switch (param) {
            case Display.KEY_DOWN:
                return FormContext.SEL_DOWN;
            case Display.KEY_UP:
                return FormContext.SEL_UP;
            case Display.KEY_RIGHT:
                return FormContext.SEL_RIGHT;
            case Display.KEY_LEFT:
                return FormContext.SEL_LEFT;
            case Display.KEY_SELECT:
                return FormContext.SEL_SELECT;
            case Display.KEY_CLEAR:
                return FormContext.SEL_CANCEL;
        }
        return FormContext.SEL_NONE;
    }
    
    public void processIMEEvent(int type, String text) {
        this.imeText = text;
        ActionHandler handler = form.getFocusedComponent();
        int selector = (type == IME_CANCELED) ? FormContext.SEL_IME_CANCEL : FormContext.SEL_IME_COMMIT;
        handler.handleAction(this, FormContext.ACT_IME_RESULT, selector);
        render();
    }
    
    private void scroll(int delta) {
        int contentHeight = this.form.getRootBlock().getHeight();
        if (delta > 0 && this.vOffset + Display.getHeight() < contentHeight) {
            this.vOffset += delta;
            if (this.vOffset + Display.getHeight() > contentHeight) {
                this.vOffset = contentHeight - Display.getHeight();
            }
        } else if (delta < 0 && this.vOffset > 0) {
            this.vOffset += delta;
            if (this.vOffset < 0) this.vOffset = 0;
        }
    }
    
    public void moveTo(int absoluteX, int absoluteY) {
//        ActionHandler component = (ActionHandler)form.getFocusedComponent();
//        if (component.isIncludedIn(0, this.vOffset, getWidth(), getHeight())) return;
//        int mid = component.getAbsoluteCenterY();
//        int bottom = ay + component.getHeight();
//        int mid = ay + component.getHeight() / 2;
        int margin = getHeight() / 2;
        if (absoluteY < margin || this.form.getRootBlock().getHeight() < getHeight()) {
            this.vOffset = 0;
        } else if (this.form.getRootBlock().getHeight() - margin < absoluteY) {
            this.vOffset = this.form.getRootBlock().getHeight() - getHeight();
        } else {
            this.vOffset = absoluteY - margin;
        }        
    }

    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.FormView#getTextByInputMethod(java.lang.String, java.lang.String, boolean)
     */
    public void launchIME(String text, String inputMode, boolean secret) {
        int mode;
        if (inputMode == FormContext.IME_SCRIPT_LATIN) {
            mode = TextBox.NUMBER;
        } else if (inputMode == FormContext.IME_SCRIPT_DIGITS) {
            mode = TextBox.NUMBER;
        } else {
            mode = TextBox.KANA;
        }
        imeOn(text, !secret ? TextBox.DISPLAY_ANY : TextBox.DISPLAY_PASSWORD, mode);
    }

    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.FormView#getIMEText()
     */
    public String getIMEText() {
        return this.imeText;
    }
    
    public byte[] getCameraData() {
        return this.cameraData;
    }
    
    public void launchCameraDevice() {
        try {            
            Camera camera = Camera.getCamera(SCAN_CAMERA_ID);
            camera.takePicture();
            camera.setAttribute(Camera.ATTR_CONTINUOUS_SHOT_OFF, 1);
            InputStream imgStream = camera.getInputStream(0);
            int inBytes = imgStream.available();
            this.cameraData = new byte[inBytes];
            imgStream.read(this.cameraData, 0, inBytes);
        } catch (RuntimeException e) {
            showErrorDialog("CAMERA f[^ǂݎ蒆RuntimeG[܂B", e);
        } catch (InterruptedOperationException e) {
            showErrorDialog("CAMERA f[^ǂݎ蒆Ɋ荞݂܂B", e);
        } catch (IOException e) {
            showErrorDialog("CAMERA f[^ǂݎ蒆IOG[܂B", e);
        }
    }
    /**
     * o[R[h̓ǂݍ݁Aǂݍ񂾕擾
     */
    public void launchCodeReader() {
        try {            
            CodeReader codeReader = CodeReader.getCodeReader(SCAN_CAMERA_ID);
            int[] codeList = codeReader.getAvailableCodes();
            codeReader.read();
            System.out.println("readCode : type = " + codeReader.getResultCode());
            this.imeText = new String(codeReader.getBytes());
        } catch (RuntimeException e) {
            showErrorDialog("QRR[hǂݎ蒆ɃG[܂B", e);
        } catch (InterruptedOperationException e) {
            showErrorDialog("QRR[hǂݎ蒆Ɋ荞݂܂B", e);
        }
    }
    
    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.FormContext#createSubmissionOperation(java.lang.String)
     */
    public SerializeOperation createSubmissionOperation(String url) {
        return new FormSubmissionOperation(this, url, null);
    }
    
    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.FormContext#createSubmissionOperation(jp.grain.xforms.SubmissionElement, boolean)
     */
    public SerializeOperation createSubmissionOperation(Submission submission) {
        String url = this.form.createCanonicalUrl(submission.getActionUrl());
        String replace = submission.getAttribute("replace");
        Node node = submission.getBindingNode();
        Instance instance = null;
        if (node == null) {
            instance = ((Model)submission.getParent()).getInstance();
            System.out.println("instance:" + instance);
            if (instance != null) {
                System.out.println("instance class:" + instance.getClass().getName());
                node = instance.getInstanceDocument().getRootElement();
            }
        }
        System.out.println("node:" + node.getClass().getName());
        FormSubmissionOperation op = null;
        if (replace != null && replace.equals("instance")) {
            Model model = (Model)submission.getParentElement();
            if (instance == null) instance = model.getInstanceBy(node);
            op =  new FormSubmissionOperation(this, instance, url, node);
        } else {
            op = new FormSubmissionOperation(this, url, node);
        }
        op.setListener(submission);
        return op;
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.FormContext#createExternalInstanceLoadOperation(jp.grian.sprout.model.Instance)
     */
    public SerializeOperation createExternalInstanceLoadOperation(Instance element) {
        String uri = element.getCanonicalSrcUri();
        String contentType = "application/xml";
        return new FormSubmissionOperation(this, element, uri, null);
    }
    
    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.FormContext#createDataLoadOperation(jp.grain.sprout.platform.doja.Image)
     */
    public SerializeOperation createDataLoadOperation(String url, DataHandler handler) {
        return new DataLoadOperation(url, handler);
    }
    
    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.FormContext#requestRender()
     */
    public void requestRender() {
        _renderingRequested = true;
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.FormContext#requestRefresh()
     */
    public void requestRefresh() {
        _refreshRequested = true;
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.FormContext#setInitializer(jp.grain.sprout.FormInitializer)
     */
    public void setInitializer(Initializer initializer) {
        _initializer = initializer;
    }

    /**
     * 
     */
    public Initializer getInitializer() {
        return _initializer;
    }

    
    public Connection createConnection(SerializeOperation op) throws IOException {
        System.out.println("opening connection = " + op.getConnectionString());
        if (op.getConnectionString() == null) {
            return null;
        } else if (op.getConnectionString().startsWith("http:")) {
            return new DividedHttpConnection(op.getConnectionString());
        } else {
            return Connector.open(op.getConnectionString(), op.getMode());
        }        
    }
    
    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.FormContext#execute(jp.grain.sprout.SerializeOperation)
     */
    public void execute(SerializeOperation op) {
        Connection conn = null;
        try {
            op.execute(this);
            System.out.println("handling serialization");
        } finally {
            try {
                System.out.println("closing connection");
                if (conn != null) conn.close();
            } catch (IOException e) {
                System.out.println("closing err");
                e.printStackTrace();
            }
        }
    }
   
    public void initBlankForm() {
        Form blankForm = new Form();
        blankForm.setRootBlock(new Block());
        Initializer initializer = new Initializer(this);
        initializer.init(blankForm);
        initializer.start();
    }

//    /* (non-Javadoc)
//     * @see jp.grain.sprout.ui.FormContext#sroteClipRect(int, int, int, int)
//     */
//    public void setClipRect(int x, int y, int width, int height) {
//        _clipX = x;
//        _clipY = y;
//        _clipWidth = width;
//        _clipHeight = height;
//    }
//
//    /* (non-Javadoc)
//     * @see jp.grain.sprout.ui.FormContext#restoreClipRect(jp.grain.sprout.ui.DrawContext)
//     */
//    public void restoreClipRect(DrawContext context) {
//        if (_clipWidth == 0 || _clipHeight ==0) return;
//        context.setAbsoluteClipRect(_clipX, _clipY, _clipWidth, _clipHeight);
//    }

    /**
     * @param e
     */
    public void showErrorDialog(String msg, Throwable t) {
        if (t != null) t.printStackTrace();
        Dialog d = new Dialog(Dialog.DIALOG_ERROR, "G[");
        d.setText(msg + "\n" + (t.getMessage() != null ? t.getMessage() : ""));
        System.out.println("show dialog : t = " + t);
        d.show();
    }
    
    public void showWarningDialog(String title, ValidationList list) {
        Dialog d = new Dialog(Dialog.DIALOG_WARNING, title);
        StringBuffer buf = new StringBuffer();
        for (Enumeration e = list.getErrors(); e.hasMoreElements();) {
            buf.append("E");
            buf.append(e.nextElement());
            buf.append("\n");
        }
        d.setText(buf.toString());
        d.show();       
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.FormContext#notifyInitializeError(java.lang.Exception)
     */
    public void notifyInitializeError(int code, Exception e) {
        System.out.println("init error : code=" + code + ", ex=" + e);
        if (code == Initializer.ERROR_UNEXPECTED) {
            showErrorDialog("ɃG[܂B", e);
        } else if (code == Initializer.ERROR_ILLEGAL_DATA_FORMAT) {
            System.out.println("init error : code=" + code + ", ex=" + e);
            showErrorDialog("擾tH[f[^̌`słB", e);
        }
    }

}
