/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/30 14:06:22
 * 
 */
package jp.grain.sprout.ui;

import java.util.Vector;

import jp.grain.spike.DefaultElement;
import jp.grain.spike.Document;
import jp.grain.spike.Element;
import jp.grain.spike.Node;
import jp.grain.spike.xpath.XPathExpr;
import jp.grain.sprout.model.Instance;
import jp.grain.sprout.model.Model;


/**
 * CAEg̊{vf
 * 
 * @version $Id: Box.java 248 2006-04-09 16:14:47Z go $
 * @author Go Takahashi
 */
abstract public class Box extends DefaultElement {
    
    /**
     * @param name
     */
    public Box(String name) {
        super(name);
    }

    public static final String NAME = "box";
    public static final int DEFAULT_BG_COLOR = 0xFFFFFF; 
    public static final int COLOR_EDGE_DARK = 0x333333; // GbW(Áj
    public static final int COLOR_EDGE_LIGHT = 0xCCCCCC; // GbW()
    
    protected int x;
    protected int y;
    protected int _width;
    protected int _height;
    protected int _margin;
    protected int _border;
    protected int _padding;
//    protected Box parent;
    protected String backgroundColor;
    private Object borderStyle;
    protected Inline _label;
    protected DefaultElement _ref;
    
    protected int _preferedWidth;
    protected int _preferedHeight;
    
    public static final String MODEL_ID = "model";

    protected boolean _enable;
    
//    protected int _maxWidth;
//    protected int _maxHeight;
    
    public void setPreferedWidth(int preferedWidth) {
        _preferedWidth = preferedWidth;
    }

    public void setPreferedHeight(int preferedHeight) {
        _preferedHeight = preferedHeight;
    }    
    
//    public void setMaxWidth(int maxWidth) {
//        _maxWidth = maxWidth;
//    }
//
//    public void setMaxHeight(int maxHeight) {
//        _maxWidth = maxHeight;
//    }
        
    public int getX() {
        return this.x;
    }
    
    public int getY() {
        return this.y;
    }
    
    public int getContentX() {
        return this._margin + this._border + this._padding;
    }
    
    public int getContentY() {
        return this._margin + this._border + this._padding;
    }
    
    public int getWidth() {
        return this._width;
    }
    
    void setWidth(int width) {
        this._width = width;
    }
    
    public int getHeight() {
        return this._height;
    }

    void setHeight(int height) {
        this._height = height;
    }
    
    public int getBoxWidth() {
        return this._width + (this._margin + this._border + this._padding) * 2;
    }

    public int getBoxHeight() {
        return this._height + (this._margin + this._border + this._padding) * 2;
    }
    
    protected Form getOwnerForm() {
        return (Form)getDocument();
    }
    
    public boolean isIncludedIn(int bx, int by, int width, int height) {
        int x = 0;
        int y = 0;
        for (Box box = this; box != null; box = (Box)box.getParentElement()) {
            x += box.x;
            y += box.y;
        }
        if (x > bx + width || y > by + height) return false;
        if (x + this._width < bx || y + this._height < by) return false;
        return true;
    }
    
    /**
     * @param x
     * @param y
     */
    public void setRelativePosition(int x, int y) {
        this.x = x;
        this.y = y;
    }
    
    public abstract void draw(DrawContext dc);
    
    public void apply(Form form) {
        applySelf(form);
        applyChildren(form);
    }    
    
    protected abstract void applySelf(Form form);
    protected abstract void applyChildren(Form form);    
    
    
    /**
     * @return
     */
    public int getAbsoluteCenterY() {
        int y = 0;
        for (Box box = this; box != null; box = (Box)box.getParentElement()) {
            y += box.y;
        }
        return (y + getBoxHeight()) / 2;
    }
    
    protected void drawCommonStyle(DrawContext dc) {
        int bgColor = dc.getColorByHex(getAttribute("background-color"));
        if (bgColor != -1 || getParentElement() == null) {
            dc.setColor((bgColor < 0) ? DEFAULT_BG_COLOR : bgColor);
            dc.fillRect(_margin, _margin, getBoxWidth() - _margin * 2, getBoxHeight() - _margin * 2);
        }
        if (this._border > 0) {
            if ("inset".equals(this.borderStyle)) {
                dc.setColor(COLOR_EDGE_DARK);
                dc.drawLine(this._margin, this._margin, getBoxWidth() - this._margin - 1, this._margin);
                dc.drawLine(this._margin, this._margin, this._margin, getBoxHeight() - this._margin - 1);
                dc.setColor(COLOR_EDGE_LIGHT);
                dc.drawLine(getBoxWidth() - this._margin - 1, this._margin, getBoxWidth() - this._margin - 1, getBoxHeight() - this._margin - 1);
                dc.drawLine(this._margin, getBoxHeight() - this._margin - 1, getBoxWidth() - this._margin - 1, getBoxHeight() - this._margin - 1);
            } else {
                dc.setColor(COLOR_EDGE_DARK);
                dc.drawRect(this._margin, this._margin, getBoxWidth() - this._margin * 2 - 1, getBoxHeight() - this._margin * 2 - 1);
            }
        }
    }
    
    public void init(Form form) {
        initAttribute(form);
        if (_binding != null) {
            form.pushContextNodeset(_binding.createContextNodeset());
            initChildren(form);
            form.popContextNodeset();
        } else {
            initChildren(form);
        }
    }
        
    protected abstract void initChildren(Form form);
    
    protected DefaultElement createRefNode(String prefix, String localname, String namespaceURI) {
		DefaultElement node = new DefaultElement(localname, prefix, namespaceURI);
		
    	return node;
    }
    
    private void initAttribute(Form form) {
        System.out.println("init attribute 1");
        if (isRootBox()) return;
        System.out.println("init attribute 2");
        _preferedWidth = getAttributeByInt("width", -1);
        _preferedHeight = getAttributeByInt("height", -1);
        System.out.println("init attribute 3");
        if (_label != null) _label.init(form);
        String refId = getAttribute("ref");
        System.out.println("init attribute 4");
        
        if(refId != null) {
        	String localname = refId;
        	String prefix = Element.DEFAULT_PREFIX;
            System.out.println("init attribute 5");
        	if(refId.indexOf(":") != -1) {
                System.out.println("init attribute 6");
        		prefix = refId.substring(0, refId.indexOf(":"));
				localname = refId.substring(refId.indexOf(":")+1);
                System.out.println("init attribute 7");
        	}
            System.out.println("init attribute 8");

            
        	Instance ctxInstance = findInstance(form);
            System.out.println("***** ctxInstance " + (ctxInstance == null));
            System.out.println("***** ctxInstance.getRootElem() " + (ctxInstance.getRootElement() == null));
        	Document doc = ctxInstance.getRootElement().getDocument();
        	Vector elements = doc.getElementsByTagName(localname);

            System.out.println("***** doc " + doc);
            System.out.println("***** elements " + elements);
        	if(elements.size() > 0) {
        		//XPath̉łȂ߁A݂͍ŏelement݂̂QƂłȂB
        		_ref = (DefaultElement)elements.elementAt(0);
        		
        	} else {
				Element rootElement = doc.getRootElement();
				_ref = createRefNode(prefix, localname, Element.DEFAULT_NAMESPACE);
				rootElement.addChild(_ref);
                System.out.println("***** rootElement " + rootElement);
        	}
        }
        
        _binding = null;
        /*
        if (_binding != null) {
            _binding.initContext(form, getAttribute("model"), true);
            _binding.evaluate();
        }*/      
    }
    
    private Instance findInstance(Form form) {
		Model ctxModel = form.getContextModel(getAttribute("model"));
        System.out.println("findinstance ctxmodel = " + (ctxModel == null));
		if(ctxModel == null) {
			//model݂Ȃ̂ō
			ctxModel = new Model();
			ctxModel.preProcess(form);
		}
		Instance ctxInstance = ctxModel.getInstance();
		if(ctxInstance == null) {
			//instancêinstance
			ctxInstance = new Instance();
			ctxInstance.preProcess(ctxModel);
		}
		
		return ctxInstance;
    }
    
    public void setLabel(Inline label) {
        _label = label;
        label.setParent(this);
    }
    
    public Inline getLabel() {
        return _label;
    }

    public boolean isBindingElement() {
        return false;
    }
    
    public Node getBindingNode() {
        //if (_binding == null) return null;
        //return _binding.getNode();
        
        return _ref;
    }
    
    /**
     * @return
     */
    public Node[] getBindingNodeset() {
        if (_binding == null) return null;
        return _binding.getNodeset();
    }

    /**
     * @param _expr
     */
    public void setBindingExpr(XPathExpr binding) {
        //_binding = binding;
    }
    
    public boolean isRootBox() {
        return getParentElement() == null;
    }

}