/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/20 14:57:21
 * 
 */
package jp.grain.sprout.ui;

import jp.grain.spike.event.Event;


/**
 * ButtonNX
 * 
 * @version $Id: Button.java 231 2006-04-08 15:20:52Z go $
 * @author Go Takahashi
 */
public class Button extends InlineComponent {

    public static final String NAME = "button";
    
    private static final int COLOR_BLACK = 0x000000; // 
    private static final int COLOR_BUTTON = 0x999999; // {^wi
    private static final int COLOR_EDGE_DARK = 0x333333; // {^GbW(Áj
    private static final int COLOR_EDGE_LIGHT = 0xCCCCCC; // {^GbW()
    private static final int COLOR_FOCUS = 0xFF6666; // {^IIF
    private static final int SIZE_BORDER = 1;
    private static final int SIZE_MARGIN = 1;
    private static final int SIZE_MINIMUM = SIZE_MARGIN + 3;
    private static final int SIZE_PADDING = 2;
    
//    private String label;
    private boolean _pressed;
    
    public Button() {
        super(NAME);
        _margin = SIZE_MARGIN;
        _border = SIZE_BORDER;
        _padding = SIZE_PADDING;
    }    
    
//    private String getLabelName() {
//        return this.label;
//    }
//    
//    public void setLabel(String label) {
//        this.label = label;
//    }
    
    public void applySelf(Form form) {
        super.applySelf(form);
        if (_width < 0) _width = _label.getBoxWidth();
        if (_width < SIZE_MINIMUM) _width = SIZE_MINIMUM;
        if (_height < _label.getBoxHeight()) _height = _label.getBoxHeight();
    }

    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.Renderer#draw(jp.haw.grain.sprout.DrawContext)
     */
    public void draw(DrawContext dc) {
        dc.setEmbossParam(_border, COLOR_BUTTON, COLOR_EDGE_LIGHT, COLOR_EDGE_DARK, _pressed);
        dc.drawEmbossedRect(_margin, _margin, _width + (_padding + _border) * 2, _height + (_padding + _border) * 2);
        if (getOwnerForm().isFocusingOn(this)) {
            dc.setColor(COLOR_FOCUS);
            dc.drawRect(0, 0, getBoxWidth() - 1, getBoxHeight() - 1);
        }
        dc.setColor(COLOR_BLACK);
        dc.clipRect(getContentX(), getContentY(), getWidth(), getHeight());
        dc.drawString(_label.getText(), getContentX(), getContentY());
        dc.clearClip();
    }

    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.InlineElement#action(int, int)
     */
    public boolean handleAction(FormContext view, int action, int selector) {
        super.handleAction(view, action, selector);
        if (selector == FormContext.SEL_SELECT) {
            if (action == FormContext.ACT_PRESSED) {
                this._pressed = true;
                return true;
            } else if (action == FormContext.ACT_RELEASED) {
                this._pressed = false;
                //TODO change dispatch mothod
                Event ev = new Event("DOMActivate", true, true);
                dispatchEvent(ev);
                return true;
            }
        }
        return false;
    }
    
    public boolean hasOuterLabel() {
        return false;
    }
}
