/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/19 16:21:04
 */
package jp.grain.sprout.ui;

import java.util.Vector;
import jp.grain.spike.Element;

/**
 * ̕vfB
 * 
 * @version $Id: CharactorSequence.java 156 2006-02-06 01:11:16Z go $
 * @author Go Takahashi
 */
public class CharactorSequence extends Inline {

    public static final String NAME = "char-seq";
            
    protected Vector chunks;
    private String _text;
    private boolean _lineBreak;
    private int _assignedLength;
    
    public CharactorSequence() {
        super(NAME);
    }
    
    public CharactorSequence(String text) {
        this();
        _text = text;
    }
    
    public CharactorSequence(CharactorSequence parent, int offset, int length) {
        this(parent.getText().substring(offset, offset + length));
        setParent(parent);
    }
        
    public String toString() {
        return _text;
    }
    
    public int getLeading(int height) {
        return height - _font.getHeight();
    }
    
    public void setLineBreak(boolean lineBreak) {
        int index = indexOfAttribute("break", -1);
        if (index < 0) {
            addAttribute("break", String.valueOf(lineBreak));
        } else {
            setAttribute(index, String.valueOf(lineBreak));
        }
    }

    public boolean isContinue() {
        if (_text == null) return false;
        return _text.length() - _assignedLength > 0;
    }
    
    public boolean fitWithIn(Row row) {
        if (_text == null || _text.length() == 0) return true;
        if (_assignedLength >= _text.length()) return true;
        int offset = _assignedLength;
        int length = _font.getLengthUntilLineBreak(_text, offset, row.getRemainingWidth());
        if (length == 0) {
            if (!row.isEmpty()) return false;
            length = 1;
        }
        if (offset == 0 && length == _text.length()) {
            if (!row.addChildInline(this)) return false;
        } else {
            CharactorSequence cs = new CharactorSequence(this, offset, length);
            cs.init(null);
            cs.apply(null);
            if (!row.addChildInline(cs)) return false;
            if (this.chunks == null) this.chunks = new Vector();
            this.chunks.addElement(cs);
        }
        _assignedLength += length;
        return true;
    }
    
    private boolean isChunk() {
        return getParent() instanceof CharactorSequence;
    }
    
    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.InlineElement#draw(jp.haw.grain.sprout.DrawContext)
     */
    public void draw(DrawContext dc) {
        drawCommonStyle(dc);
        dc.setColor(DrawContext.COLOR_BLACK);
        dc.setFont(_font);
        dc.drawString(getText(), 0, 0);
    }
    
    public void applySelf(Form form) {
        this.chunks = null;
        _assignedLength = 0;
//        _font = isChunk() ? Font.getFontOf((Inline)getParent()) : Font.getFontOf(this);
        _width = _font.getWidth(getText());
        _height = getInheritedAttributeByInt("line-height", -1);
        if (_height < 0) {
            _height = _font.getHeight();
        }
    }
    
    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.InlineElement#action(jp.haw.grain.sprout.FormView, int, int)
     */
    public boolean action(FormContext view, int action, int selector) {
        // TODO Auto-generated method stub
        return false;
    }

    /**
     * @see
     */
    public String getText() {
        return (_text != null) ? _text : "";
    }
    
    public Element setText(String text) {
        _text = text;
        return this;
    }
    
}
