/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/14 16:38:51
 * 
 */
package jp.grain.sprout.ui;

import jp.grain.spike.Element;
import jp.grain.spike.Node;
import jp.grain.spike.xpath.XPathExpr;

/**
 * TODO GubAttribute
 * 
 * @version $Id: GudAttribute.java 211 2006-04-07 09:00:10Z nakajo $
 * @author Go Takahashi
 */
public class GudAttribute extends Element {
   
    
    private String _value;
    private XPathExpr _expr;

	/**
	 * @param name
	 * @param prefix
	 * @param namespace
	 */
	public GudAttribute(String name, String prefix, String namespace) {
		super(name, prefix, namespace);
	}

    /**
     * @param name 
     * @param name
     */
    public GudAttribute(String name) {
        super(name);
    }

        
    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.GudElement#setText(java.lang.String)
     */
    public Element setText(String text) {
        _value = text;
        return this;
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.GudElement#preProcess(jp.grain.sprout.ui.GudElement)
     */
    public void preProcess(Node parent) {
//        if (parent instanceof GudAttribute) {
//            Element element = (Element)parent;
//            if ("item".equals(getName())) {
//                element.addChild(this);
//            }
//        }
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.GudElement#postProcess(jp.grain.sprout.ui.GudElement)
     */
    public void postProcess(Node parent) {
        if ("label".equals(getName())) {
            if (parent instanceof InlineComponent) {
                CharactorSequence cs = new CharactorSequence(_value);
                ((InlineComponent)parent).setLabel(cs);
            } else if (parent instanceof BlockLevel) {
                CharactorSequence cs = new CharactorSequence(_value);
                ((BlockLevel)parent).setLabel(cs);
            }
        } else if ("name".equals(getName())) {
            if (parent instanceof Item) {
                Item item = (Item)parent;
                item.setLabel(_value);
            }
        } else if ("value".equals(getName())) {
            if (parent instanceof Item) {
                Item item = (Item)parent;
                item.setValue(_value);
            }
        } else if ("choices".equals(getName())) {
            if (parent instanceof SelectComponent) {
				SelectComponent selectC = (SelectComponent)parent;    
                for (int i = 0; i < getChildCount(); ++i) {
					selectC.addChild(this.getChildElement(i));
                }
            }
        } else if ("binding".equals(getName())) {
            if (parent instanceof Box) {
                Box item = (Box)parent;
                item.setBindingExpr(_expr);
            }
        }
    }

    /**
     * @param expr
     */
    public void setXPathExpr(XPathExpr expr) {
        _expr = expr; 
    }
}
