/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/22 6:09:30
 * 
 */
package jp.grain.sprout.ui;

/**
 * TODO Component
 * 
 * @version $Id: InlineComponent.java 156 2006-02-06 01:11:16Z go $
 * @author Go Takahashi
 */
public abstract class InlineComponent extends Inline implements ActionHandler {

    /**
     * @param name
     */
    public InlineComponent(String name) {
        super(name);
    }

    protected boolean _activate;
        
    protected void applySelf(Form form) {
        form.registerNavigation(0, this);
        _width = _preferedWidth;
        _height = _preferedHeight;
        if (_label != null) _label.apply(form);
    }
    
    public boolean fitWithIn(Row row) {
        if (hasOuterLabel() && _label != null) {
            if (!_label.fitWithIn(row)) return false;
        }
        return super.fitWithIn(row);
    }
        
    public boolean handleAction(FormContext ctx, int action, int selector) {
        if (action == FormContext.ACT_FOCUS_IN) {
    //TODO dispatch event
    //      if (this.element instanceof FormControlElement) {
    //          ((FormControlElement)this.element).dispatchEvent(new Event("DOMFocusIn", true, false));
    //      }
        } else if (action == FormContext.ACT_FOCUS_OUT) {
    //TODO dispatch event
    //      if (this.element instanceof FormControlElement) {
    //          ((FormControlElement)this.element).dispatchEvent(new Event("DOMFocusOut", true, false));
    //      }
        }
        return false;
    }
    
    /**
     * @return
     */
    public boolean isCaptureEnable() {
        return _activate;
    }

    /**
     * @param label
     */
    public void setLabel(Inline label) {
        _label = label;
        _label.setParent(this);
    }
    
    public boolean hasOuterLabel() {
        return true;
    }
    
    public boolean isBindingElement() {
        return true;
    }

}
