/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/18 14:52:22
 * 
 */
package jp.grain.spike;

import java.util.Vector;

/**
 * TODO Element
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public abstract class Element extends Node {
    
    public static final String DEFAULT_PREFIX = null;
    public static final String DEFAULT_NAMESPACE = "";
    
    protected String _name;
    protected String _prefix;
    protected String _namespace;
    protected Vector _children;
    protected Vector _attributes;
    protected Vector _namespaces;

    public Element(String name) {
        this(name, DEFAULT_PREFIX, DEFAULT_NAMESPACE);
    }
    
    public Element(String name, String prefix, String namespace) {
        _name = name;
        _prefix = prefix;
        _namespace = namespace;
    }
     
    public String toString() {
    	String str = this.getClass().getName();
    	str += "[namespaceUri="+this._namespace+" qname="+this._prefix+":"+this._name+"]";
    	if(this._children != null) {
    		str += "children="+this._children.size();
    	}
    	
    	return str;
    }
    /**
     * @return ̗vf̖O
     */
    public String getName() {
        return _name;
    }
    
    public String getNamespace() {
        return _namespace;
    }
    
    public String getPrefix() {
        return _prefix;
    }
    
    public void setChildren(Vector children) {
        _children = children;
    }
    
    public Vector getChildren() {
        return _children;
    }
    
    public Element addChild(Node child) {
        return addChild(-1, child);
    }
    
    public Element addChild(int index, Node child) {
        if (_children == null) {
            _children = new Vector();
        }
        if (index < 0) {
            _children.addElement(child);
        } else {
            _children.insertElementAt(child, index);
        }
        child.setParent(this);
        return this;
    }
    
    public int getChildCount() {
        if (_children == null) return 0;
        return _children.size();
    }
    
    public Object getChild(int index) {
        if (_children == null) throw new IndexOutOfBoundsException(String.valueOf(index));
        return _children.elementAt(index);
    }
    
    public Element getChildElement(int index) {
        if (_children == null) throw new IndexOutOfBoundsException(String.valueOf(index));
        Object obj = _children.elementAt(index);
        if (obj != null && obj instanceof Element) return (Element)obj;
        return null;
    }
    
    protected Node getChild(int index, Class clazz) {
//        if (!isAssignableFrom(clazz)) throw new IllegalArgumentException("unable to cast : " + clazz);
        if (_children == null) throw new IndexOutOfBoundsException(String.valueOf(index));
        Object obj = _children.elementAt(index);
        if (clazz.isInstance(obj)) return (Node)obj;
        return null;        
    }
    
    public String getText() {
    	/*
        if (_children == null || _children.isEmpty()) return null;
        Object obj = _children.elementAt(0);
        if (obj instanceof String) return (String)obj;
        return null;
        */
        return getSimpleContent();
    }
    
    public String getChildText(int index) {
        if (_children == null) throw new IndexOutOfBoundsException(String.valueOf(index));
        Object obj = _children.elementAt(index);
        if (obj instanceof String) return (String)obj;
        return null;
    }
    
    public Element setText(String text) {
    	/*
        if (_children == null) {
            _children = new Vector();
        } else {
            _children.removeAllElements();
        }
        _children.addElement(text);*/
        setSimpleContent(text);
        
        return this;
    }
    
    public Element addChildText(String text) {
        if (_children == null) {
            _children = new Vector();
        }
        _children.addElement(text);
        return this;
    }

    public void removeChild(int index) {
        if (_children == null) throw new IndexOutOfBoundsException(String.valueOf(index));
        _children.removeElementAt(index);
    }
    
    public int indexOfChild(String name, int startIndex) {
        return indexOfChild(null, name, startIndex);
    }

    public int indexOfChild(String namespace, String name, int startIndex) {
        if (_children == null) return -1;
        for (int i = startIndex; i < _children.size(); ++i) {
            Object obj = _children.elementAt(i);
            if (!(obj instanceof Element)) continue;
            Element elem = (Element)obj;
            if (namespace != null && !namespace.equals(elem._namespace)) continue;
            if (!name.equals(elem._name)) continue;
            return i;
        }
        return -1;
    }

    protected int indexOfChild(Class clazz, int startIndex) {
        if (_children == null) return -1;
        for (int i = startIndex; i < _children.size(); ++i) {
            Object obj = _children.elementAt(i);
            if (!clazz.isInstance(obj)) continue;
            return i;
        }
        return -1;        
    }
    
    public int getAttributeCount() {
        if (_attributes == null) return 0;
        return _attributes.size();
    }
    
    public String getAttributeName(int index) {
        if (_attributes == null) throw new IndexOutOfBoundsException(String.valueOf(index));
        return ((Attribute)_attributes.elementAt(index))._name;
    }

    public String getAttributeValue(int index) {
        if (_attributes == null) throw new IndexOutOfBoundsException(String.valueOf(index));
        return ((Attribute)_attributes.elementAt(index))._value;
    }

    public String getAttributePrefix(int index) {
        if (_attributes == null) throw new IndexOutOfBoundsException(String.valueOf(index));
        return ((Attribute)_attributes.elementAt(index))._prefix;
    }    

    public String getAttributeNamespace(int index) {
        if (_attributes == null) throw new IndexOutOfBoundsException(String.valueOf(index));
        return ((Attribute)_attributes.elementAt(index))._namespace;
    }    
   
    public Element setAttribute(int index, String value) {
        if (_attributes == null) throw new IndexOutOfBoundsException(String.valueOf(index));
        ((Attribute)_attributes.elementAt(index))._value = value;
        return this;
    }    
    
    public String getAttribute(String name) {
        int index = indexOfAttribute(name, 0);
        if (index < 0) return null;
        return getAttributeValue(index);
    }

    public String getAttribute(String name, String namespce) {
        int index = indexOfAttribute(name, namespce, 0);
        if (index < 0) return null;
        return getAttributeValue(index);
    }
        
    public String getInheritedAttribute(String name) {
        for (Element e = this; e != null; e = e.getParentElement()) {
            String attribute = e.getAttribute(name);
            if (attribute != null) return attribute;
        }
        return null;
    }

//    public int getInheritedStyleByInt(String name, int defaultValue) {
//        String style = getInheritedAttribute("style");
//        int pos = style.indexOf(':');
//        
//    }
    
    public int getInheritedAttributeByInt(String name, int dafaultValue) {
        String value = getInheritedAttribute(name);
        return value == null ? dafaultValue : Integer.parseInt(value);
    }

    public int getAttributeByInt(String name, int dafaultValue) {
        String value = getAttribute(name);
        return value == null ? dafaultValue : Integer.parseInt(value);
    }
    
    public Element addAttribute(String name, String prefix, String namespace, String value) {
        return addAttribute(-1, name, prefix, namespace, value);
    }
    
    public Element addAttribute(int index, String name, String prefix, String namespace, String value) {
        addAttribute(index, new Attribute(name, prefix, namespace, value));
        return this;
    }
    
    public Element addAttribute(String name, String value) {
        return addAttribute(-1, name, value);
    }
    
    public Element addAttribute(int index, String name, String value) {
        addAttribute(index, new Attribute(name, value));
        return this;
    }
    
    protected void addAttribute(int index, Attribute attr) {
        if (_attributes == null) {
            _attributes = new Vector();
        }
        if (index < 0) {
            _attributes.addElement(attr);
        } else {
            _attributes.insertElementAt(attr, index);
        }
        attr.setOwnerElement(this);
    }
    
    public int indexOfAttribute(String name, int startIndex) {
        return indexOfAttribute(name, DEFAULT_NAMESPACE, startIndex);
    }
    
    public int indexOfAttribute(String name, String namespace, int startIndex) {
        if (_attributes == null) return -1; 
        for (int i = 0; i < _attributes.size(); ++i) {
            Attribute attr = (Attribute)_attributes.elementAt(i);
            if (!attr._name.equals(name)) continue;
            if (attr._namespace == namespace) return i;
            if (namespace != null && namespace.equals(attr._namespace)) return i;
        }
        return -1;
    }
    
    public void addPrefixMapping(String prefix, String namespace) {        
        if (_namespaces == null) {
            _namespaces = new Vector();
        }
        _namespaces.addElement(new Namespace(prefix, namespace));
    }
    
    public String getPrefix(int index) {
        if (_namespaces == null) throw new IndexOutOfBoundsException(String.valueOf(index));
        return ((Namespace)_namespaces.elementAt(index))._prefix;
    }
    
    public String getNamespace(int index) {
        if (_namespaces == null) throw new IndexOutOfBoundsException(String.valueOf(index));
        return ((Namespace)_namespaces.elementAt(index))._uri;
    }

    public int getPrefixMapCount() {
        if (_namespaces == null) return 0;
        return _namespaces.size();
    }
    
    public class Namespace {

        public String _prefix;
        public String _uri;

        /**
         * @param prefix
         * @param namespace
         */
        public Namespace(String prefix, String uri) {
            _prefix = prefix;
            _uri = uri;
        }
    }

    public Attribute[] getAttributes() {
        int size = _attributes == null ? 0 : _attributes.size();
        Attribute[] attrs = new Attribute[size]; 
        _attributes.copyInto(attrs);
        return attrs;
    }
    
    public Namespace[] getNamespaces() {
    	if(_namespaces == null) return new Namespace[0];
        int size = _namespaces.size();
        Namespace[] ns = new Namespace[size]; 
        _namespaces.copyInto(ns);
        return ns;
    }
    
    /**
     * @param i
     * @return
     * @deprecated
     */
    public Node getFirstChild() {
        if (_children == null || _children.isEmpty()) return null;
        return (Node)_children.elementAt(0);
    }
    
    

    public String getSimpleContent() {
        for (int i = 0; i < getChildCount(); ++i) {
            Object child = getChild(i);
            if (child instanceof String) return (String)child;
        }
        return Node.EMPTY_STRING;
    }

    public void setSimpleContent(String content) {
        for (int i = 0; i < getChildCount(); ++i) {
            Object child = getChild(i);
            if (child instanceof String) {
                _children.setElementAt(content, i);
                return;
            }
        }
        addChildText(content);
    }

    /**
     * @param bindingNode
     * @param node
     */
    public void replace(Node src, Node dst) {
        int index = _children.indexOf(src);
        if (index < 0) return;
        _children.setElementAt(dst, index);
    }

}
