/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/18 14:40:45
 * 
 */
package jp.grain.spike;

/**
 * TODO Node
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public abstract class Node {
    public static final int NODE_TYPE_ELEMENT = 0;
    public static final int NODE_TYPE_ATTRIBUTE = 1;
    public static final int NODE_TYPE_DOCUMENT = 2;
    public static final int NODE_TYPE_CDATA = 3;
    
    public static final String EMPTY_STRING = "";
    
    Node _parent;
    
    public Node getParent() {
        return _parent;
    }
    
    public Document getDocument() {
        for (Node p = _parent; p != null; p = p.getParent()) {
           if (p.getNodeType() == Node.NODE_TYPE_DOCUMENT) return (Document)p;
        }
        return null;
    }
    
    public void setParent(Node parent) {
        _parent = parent;
    }
    
    public Element getParentElement() {
        if (_parent.getNodeType() == Node.NODE_TYPE_ELEMENT) return (Element)_parent;
        return null;
    }
    
    public boolean equals(Object obj) {
    	if(this.getClass().equals(obj.getClass())) {
    		return this.hashCode() == obj.hashCode();
    	}
    	
        return false;
    }
    
    public String toString() {
        return EMPTY_STRING;
    }
    
    abstract public void preProcess(Node parent);
    abstract public void postProcess(Node parent);
    
    abstract public int getNodeType();
    
    /**
     * @return
     */
    public Node clone() {
        return null;
    }

    /**
     * @return
     */
    public abstract String getSimpleContent();

    /**
     * @param content
     */
    public abstract void setSimpleContent(String content);

}
