/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/21 16:11:59
 * 
 */
package jp.grain.sprout.ui;

import com.nttdocomo.lang.IllegalStateException;

import jp.grain.spike.Element;
import jp.grain.spike.Node;
import jp.grain.sprout.model.Model;


/**
 * {bNXvfł镨CAEgvfB
 * CCvf𒼐ځA邱Ƃ͂łȂB
 * 
 * @version $Id: Block.java 204 2006-04-06 10:50:23Z go $
 * @author Go Takahashi
 */
public class Block extends AbstractBlock {

    public static final String NAME = "block";
    
    //protected Vector children = new Vector();
    
    
    public Block() {
        this(NAME);
    }

    public Block(String name) {
        this(name, 0);
    }
    
    public Block(String name, int preferedWidth) {
        super(name);
        _preferedWidth = preferedWidth;
    }
    
    protected void initChildren(Form form) {
        for (int i = 0; i < getChildCount(); ++i) {
            Box box = (Box)getChildElement(i);
            if (box == null) continue;
            box.init(form);
        }
    }
    
    protected void applySelf(Form form) {
        _width = _preferedWidth;
        _height = _preferedHeight;
        if (_width < 0) {
            if (this.getParentElement() != null) {
                _width = ((Box)getParentElement()).getWidth() - (_margin + _padding + _border) * 2;
            } else {
                throw new IllegalStateException("root block width is 0");
            }
        }        
    }
    
    protected void applyChildren(Form form) {
        if (_children == null) {
            if (_height < 0) _height = 0;
            return;
        }
        _height = 0;
        for (int i = 0; i < _children.size(); ++i) {
            Box box = (Box)_children.elementAt(i);
            box.setRelativePosition(0, _height);
            box.apply(form);
            _height += box.getBoxHeight();
        }
    }
    
    /* (non-Javadoc)
     * @see jp.haw.grain.xforms.Block#addChildBox(jp.haw.grain.xforms.Box)
     */
    public void addChildBlock(AbstractBlock child) {
        if (!(child instanceof Box)) throw new IllegalArgumentException(child.toString()); 
        addChild(child);
    }
    
    /* (non-Javadoc)
     * @see jp.haw.grain.xforms.Block#getChildBox(int)
     */
    public Box getChildBox(int index) {
        return (Box)getChildElement(index);
    }

    public void draw(DrawContext dc) {
        drawCommonStyle(dc);
        if (_children == null) return;
        DrawContext childCtx = dc.createContext(getContentX(), getContentY());
        for (int i = 0; i < _children.size(); ++i) {
            Box child = (Box)_children.elementAt(i);
            child.draw(childCtx.moveTo(child.x, child.y));
        }
    }
    
    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.GudElement#preProcess(jp.grain.sprout.ui.GudElement)
     */
    public void preProcess(Node parent) {
        if (parent instanceof Form) {
            Form form = (Form)parent;
            if (form.getRootBlock() != null) return;
            form.setRootBlock(this);
        } if (parent instanceof Block) {
            ((Block)parent).addChildBlock(this);
        }
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.GudElement#postProcess(jp.grain.sprout.ui.GudElement)
     */
    public void postProcess(Node parent) {
        // TODO Auto-generated method stub        
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.GudElement#setText(java.lang.String)
     */
    public Element setText(String text) {
        return this;
    }
    
    /* (non-Javadoc)
     * @see jp.grain.spike.Element#getText()
     */
    public String getText() {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Element#getChildText(int)
     */
    public String getChildText(int index) {
        // TODO Auto-generated method stub
        return null;
    }
}
