/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/11/20 13:53:44
 * 
 */
package jp.grain.sprout.ui;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

import jp.grain.spike.Document;
import jp.grain.spike.Element;
import jp.grain.spike.Node;
import jp.grain.spike.event.Event;
import jp.grain.sprout.model.Model;


/**
 * TODO Session
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Form extends Document {

    public static final String NAME = "form";
    
    private Vector _models = new Vector();
    private Vector _handlers = new Vector();
    private String _url;
    private Hashtable _idMap = new Hashtable();
    private int _navigationIndex;
    
    private boolean _enable = true;
    
    private Stack _bindingElements = new Stack();

    private FormContext _context;

    
    private Stack _ctxModelStack = new Stack();
    private Hashtable _ctxNodeMap = new Hashtable();

    /**
     * @param dc
     */
    public void draw(DrawContext dc) {
        dc.clearClip();
        clearBoundary(dc);
        getRootBlock().draw(dc);
        dc.drawFloating();
    }

    private void clearBoundary(DrawContext dc) {
        if (_handlers.size() == 0) return;
        InlineComponent component = (InlineComponent)_handlers.lastElement();
        int height = component.getHeight();
        dc.clearRect(0, height, 1000, 1000);
        /**
         * Note: The function's primary purpose is to delete floating objects [see: ticket 17] 
         * (e.g. Choice's drop-down list). The floating objects may span multiple lines
         * which is dependent on the GUD and screen size, therefore a value high enough is set to width
         * and height (e.g. 1000, 1000 respectively), other appropriate values may be set.
         */
    }

    /**
     * @param uri
     */
    public void setBaseUrl(String url) {
        _url = url;        
    }
    
    public String getBaseUrl() {
        return _url;
    }

    public FormContext getContext() {
        return _context;
    }
    
    /**
     * @param attrValue
     * @param box
     */
    public void regist(String id, Node node) {
        // TODO Auto-generated method stub
        this._idMap.put(id, node);
    }
    
    public Node find(String id) {
        if (id == null) return null;
        return (Node)this._idMap.get(id);
    }

    /**
     * @param gud
     */
    public void setRootBlock(Block block) {
//        if (!(block instanceof Element)) throw new IllegalArgumentException();
        setRootElement((Element)block);
    }
    
    /**
     * @return
     */
    public Block getRootBlock() {
        return (Block)getRootElement();
    }

    /**
     * @param writer
     */
    public void toXml(OutputStreamWriter writer) {
        // TODO Auto-generated method stub
    }

    /**
     * @throws IOException 
     * 
     */
    public void init(FormContext context) throws IOException {
    	System.out.println("FORM INIT: Called");
        _context = context;
        _context.formInitStart();
        
        processModelConstruct();
        processModelConstructDone();
        processReady();
                       
    }

    /**
     * @throws IOException 
     * 
     */
    private void processModelConstruct() throws IOException {
        for (int i = 0; i < _models.size(); ++i) {
            Model model = (Model)_models.elementAt(i);
            Event ev = new Event("xforms-model-construct", true, false);
            model.dispatchEvent(ev);
            if (ev.isPreventDefault()) continue;
            System.out.println("dispatch xforms-model-construct : model=" + i);
            // default action
            model.init(_context);
            model.rebuild();
            model.recalculate();
            model.revalidate();
        }
    }

    /**
     * 
     */
    private void processModelConstructDone() {
        for (int i = 0; i < _models.size(); ++i) {
            Model model = (Model)_models.elementAt(i);
            Event ev = new Event("xforms-model-construct-done", true, false);
            model.dispatchEvent(ev);
            if (ev.isPreventDefault()) continue;
            System.out.println("dispatch xforms-model-construct-done : model=" + i);
            // default action
        }
        getRootBlock().init(this);
    }
    
    /**
     * 
     */
    private void processReady() {
        for (int i = 0; i < _models.size(); ++i) {
            Model model = (Model)_models.elementAt(i);
            Event ev = new Event("xforms-model-ready", true, false);
            model.dispatchEvent(ev);
            if (ev.isPreventDefault()) continue;
            System.out.println("dispatch xforms-model-ready : model=" + i);
            // default action
            // nothing to do : notification event only
        }
    }
    
    /**
     * 
     */
    public void layout() {
        ActionHandler current = getFocusedComponent();
        _handlers.removeAllElements();
        getRootBlock().apply(this);
        _navigationIndex = _handlers.indexOf(current);
        if (_navigationIndex < 0) _navigationIndex = 0;
    }

    /**
     * @return
     */
    public int getModelCount() {
        return _models.size();
    }
    
    public Model getModel(int index) {
        System.out.println("get model : model size = " + _models.size());
    	if(_models.size() == 0) return null;
        return (Model)_models.elementAt(index);
    }

    public void addModel(Model model) {
        _models.addElement(model);
        model.setParent(this);
    }
        
    /**
     * @param index
     * @param c
     */
    public void registerNavigation(int index, ActionHandler component) {
    	System.out.println("REGIST_NAVIGATION: component="+component.getClass().getName());
    	if(_handlers.contains(component)) _handlers.removeElement(component);
    	System.out.println("REGIST_NAVIGATION: remove size="+_handlers.size());
        _handlers.addElement(component);
    	System.out.println("REGIST_NAVIGATION: add size="+_handlers.size());
    }
    
//    /**
//     * @param parentNode
//     * @return
//     * @deprecated
//     */
//    public static RenderableElement getImmediatelyEnclosingElementOf(Node node) {
//        for (Element e = node.getParentElement(); e != null; e = e.getParentElement()) {
//            if (e instanceof Box) return /*(RenderableElement)e*/ null;
//        }
//        return null;
//    }

    public boolean handleEvent(FormContext ctx, int action, int selector) {
        ActionHandler handler = getFocusedComponent();
        boolean handled = handler.handleAction(ctx, action, selector);
        if (handled) return false;
        if (action == FormContext.ACT_RELEASED) {
            if (selector == FormContext.SEL_DOWN || selector == FormContext.SEL_UP) {
                ActionHandler renewed = (selector == FormContext.SEL_DOWN) ? nextNavigation() : previousNavigation();
                if (handler == renewed) return false;
                handler.handleAction(ctx, FormContext.ACT_FOCUS_OUT, FormContext.SEL_NONE);
                ctx.moveTo(0, handler.getAbsoluteCenterY());
                renewed.handleAction(ctx, FormContext.ACT_FOCUS_IN, FormContext.SEL_NONE);                
                ctx.requestRender();
            }
        }
        return false;
    }
    
    /**
     * @param button
     * @return
     */
    public boolean isFocusingOn(ActionHandler handler) {
        if (_handlers.isEmpty()) return false;
        ActionHandler current = (ActionHandler)_handlers.elementAt(_navigationIndex);
        return handler == current;
    }
 
    public ActionHandler nextNavigation() {
        if (_handlers.isEmpty()) return NullComponent.INSTANCE;
        int next = _navigationIndex + 1;
        _navigationIndex = next < _handlers.size() ? next : 0;
        return (ActionHandler)_handlers.elementAt(_navigationIndex);
    }

    public ActionHandler previousNavigation() {
        if (_handlers.isEmpty()) return NullComponent.INSTANCE;
        int prev = _navigationIndex - 1;
        _navigationIndex = prev < 0 ? _handlers.size() - 1 : prev;
        return (ActionHandler)_handlers.elementAt(_navigationIndex);
    }
    
    public ActionHandler getFocusedComponent() {
        if (_handlers.isEmpty()) return NullComponent.INSTANCE;
		ActionHandler handl = (ActionHandler)_handlers.elementAt(_navigationIndex);
		System.out.println("handl="+handl.getClass().getName());
        return handl;
    }
     
    
    
    /**
     * @param block
     */
    public void pushContextNodeset(ContextNodeset contextNodeset) {
        _bindingElements.push(contextNodeset);
    }
    
    /**
     * @param block
     */
    public void popContextNodeset() {
        if (_bindingElements.isEmpty()) throw new RuntimeException();
        _bindingElements.pop();
    }
    
        
    public Model getContextModel(String id) {
        
        System.out.println("get context mode id = " + id);

        // 7.4-3-a: context model which 'model' atttibeute determines is used
        if (id != null) {
            Node node = find(id);
            if (node != null && node instanceof Model) return (Model) node; 
        }
                
        // 7.4.3-b: The context model of immediately enclosing element is used
        if (!_bindingElements.isEmpty()) {
            ContextNodeset contextNodeset = (ContextNodeset)_bindingElements.peek();
            return contextNodeset.getModel();
        }
        
        // 7.4-3-c: The first model in document order is used (when no 'model' attribute was supplied)
        return (Model)getModel(0);
    }
   
    


    
    
    public Stack getBindingElements() {
        return _bindingElements;
    }

    /**
     * 
     */
    public static void init() {
        FormBuilder.registerComponent(NAME, new Form().getClass());
    }
    
    public void setEnable(boolean enable) {
        _enable = enable;
    }
    
    public boolean getEnable() {
        return _enable;
    }

    public String createCanonicalUrl(String url) { 
        String baseUrl = getBaseUrl();
        if (url.startsWith("http://")) return url;
        return baseUrl.substring(0, baseUrl.lastIndexOf('/') + 1) + url;
    }

    
    
    
    // 20060521ǉ
    private Model getContextModel() {
        if (_ctxModelStack.isEmpty()) {
            // 7.4-3-c: The first model in document order is used (when no 'model' attribute was supplied)
            return (Model)getModel(0);
        } else {
            // 7.4.3-b: The context model of immediately enclosing element is used
            return (Model)_ctxModelStack.peek();
        }        
    }
    
    public void pushContextModel(Model model) {
        _ctxModelStack.push(model);
    }

    public Model popContextModel() {
        return (Model)_ctxModelStack.pop();        
    }
    
    public Node getContextNode() {
        Model model = getContextModel();
        Stack stack = (Stack)_ctxNodeMap.get(model);
        if (stack == null || stack.isEmpty()) {
            return model.getInstance().getRootElement();
        } else {
            return (Node)stack.peek();
        }
    }

    public void pushContextNode(Node contextNode) {
        Model model = getContextModel();
        if (_ctxModelStack.isEmpty()) {
            _ctxModelStack.push(model);
        }
        Stack stack = (Stack)_ctxNodeMap.get(model);
        if (stack == null) {
            stack = new Stack();
            _ctxNodeMap.put(model, stack);
        }
        stack.push(contextNode);
    }

    public void popContextNode() {
        Model model = getContextModel();
        Stack stack = (Stack)_ctxNodeMap.get(model);
        stack.pop();
    }

    
//    /* (non-Javadoc)
//     * @see jp.grain.sprout.ui.FormContext#execute(jp.grain.sprout.SerializeOperation)
//     */
//    public void execute(SerializeOperation op) {
//        Connection conn = null;
//        try {
//            conn = _context.createConnection(op);
//            op.execute(conn);
//            System.out.println("handling serialization");
//        } catch (IOException e) {
//            // skip error
//            _context.showErrorDialog("ʐMG[ɂtH[̎擾Ɏs܂B\n{ݒmFĂB\n", e);
//        } catch (XmlPullParserException e) {
//            _context.showErrorDialog("擾tH[̉͂͂ł܂B\n", e);
//        } finally {
//            try {
//                System.out.println("closing connection");
//                if (conn != null) conn.close();
//            } catch (IOException e) {
//                System.out.println("closing err");
//                e.printStackTrace();
//            }
//        }
//    }
    
    
}
