/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/30 4:26:01
 * 
 */
package jp.grain.sprout.ui;

import jp.grain.spike.Node;
import jp.grain.sprout.model.Model;

/**
 * TODO EvalContext
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class ContextNodeset {

    private Model _model;
    private Node[] _nodeset;

    public ContextNodeset(Model model, Node[] nodeset) {
        _model = model;
        _nodeset = nodeset;
    }

    public ContextNodeset(Model model, Node node) {
        _model = model;
        _nodeset = new Node[] { node };
    }

    /**
     * @return
     */
    public Model getModel() {
        return _model;
    }
    
    public Node[] getNodeset() {
        return _nodeset;
    }
}
