/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/20 17:26:36
 * 
 */
package jp.grain.sprout.ui;

import java.util.Vector;

import jp.grain.spike.Node;

/**
 * CCvf镨CAEgvf
 * {bNXvf邱Ƃ͂łȂB
 * 
 * @version $Id: InlineBlock.java 242 2006-04-09 08:19:37Z go $
 * @author Go Takahashi
 */
public class InlineBlock extends AbstractBlock {

    public static final String NAME = "inline-block";
    
    protected Vector rows = new Vector();
    private boolean lineBreak;
    private boolean fictional;
    
    // psuide column
    public InlineBlock() {
        this(false);
    }
    
    public InlineBlock(boolean fictional) {
        super(NAME);
        this.fictional = fictional;
    }
    
    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.Box#init()
     */
    protected void initChildren(Form form) {
        for (int i = 0; i < getChildCount(); ++i) {
            Inline inline = (Inline)getChildElement(i);
            if (inline == null) continue;
            inline.init(form);
        }        
    }
        
    protected void applySelf(Form form) {
        _width = _preferedWidth;
        _height = 0;
        if (_width < 0) {
            if (getParent() != null) {
                _width = ((Block)getParent()).getBoxWidth();
            } else {
                _width = 0;
            }
        }        
    }    
    
    protected void applyChildren(Form form) {
        this.rows.removeAllElements();
        Inline inline = null;
        for (int index = 0, applyed = 0; index < getChildCount();) {
            Row row = new Row(getBoxWidth());
            while (index < getChildCount()) {
                if (inline == null || applyed < index) {
                    if (applyed < index) applyed = index;
                    inline = (Inline)getChildElement(applyed);                    
                    inline.apply(form);
                }
                if (!inline.fitWithIn(row)) {
                    break;
                } else if (inline.isLineBreak()) {
                    ++index;
                    break;
                }
                if (!inline.isContinue()) ++index;
            }
            row.setRelativePosition(0, this._height);
            row.setParent(this);
            row.apply(form);
            _height += row.getBoxHeight();
            System.out.println(getClass().getName() + "child box height=" + row.getBoxHeight());
            this.rows.addElement(row);
            row.setParent(this);
        }
        System.out.println(getClass().getName() + "height=" + _height);
    }

    public int getRowCount() {
        return this.rows.size();
    }
    
    public Row getRow(int index) {
        return (Row)this.rows.elementAt(index);
    }

    public void addChildInline(Inline child) {
        addChild(child);
    }

    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.Renderer#draw(jp.haw.grain.sprout.DrawContext)
     */
    public void draw(DrawContext dc) {
        drawCommonStyle(dc);
        DrawContext childCtx = dc.createContext(getContentX(), getContentY());
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = (Row)this.rows.elementAt(i);
            row.draw(childCtx.moveTo(row.x, row.y));
        }
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.GudElement#preProcess(jp.grain.sprout.ui.GudElement)
     */
    public void preProcess(Node parent) {
        if (parent instanceof Block) {
            ((Block)parent).addChild(this);
        }
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.GudElement#postProcess(jp.grain.sprout.ui.GudElement)
     */
    public void postProcess(Node parent) {
        // TODO Auto-generated method stub
    }

}
