package jp.grain.sprout.ui;

import java.util.Vector;

/**
 * @author nakajo
 */
public abstract class SelectComponent extends InlineComponent {

	protected static final int COLOR_BLACK = 0x000000; // 
	protected static final int COLOR_BUTTON = 0x999999; // {^wi
	protected static final int COLOR_EDGE_DARK = 0x333333; // {^GbW(Áj
	protected static final int COLOR_EDGE_LIGHT = 0xCCCCCC; // {^GbW()
	protected static final int COLOR_FOCUS = 0xFF6666; // {^IIF
	protected static final int COLOR_FIELD = 0xFFFFFF; // wi
	protected static final int SIZE_BORDER = 1;
	protected static final int SIZE_MARGIN = 1;
	protected static final int SIZE_MINIMUM = SIZE_MARGIN + 3;
	protected static final int SIZE_PADDING = 2;
	protected static final int SIZE_ARROW = 7;
	protected static final int SIZE_ARROW_MARGIN = 1;
	protected static final int SIZE_ARROW_EDGE = 1;

	protected String label;
	protected boolean _pressed;
	protected int _selectionIndex;
	protected int _currentIndex;
    
	protected boolean _isMultiple;
	protected Vector _selections;
    
	public SelectComponent(String name) {
		super(name);
		_margin = SIZE_MARGIN;
		_border = SIZE_BORDER;
		_padding = SIZE_PADDING;
	}
    
	public void apply(Form form) {
		super.apply(form);
		int maxContentWidth = 0;
		_selections = new Vector();
		if (_width < 0) {
			for (int i = 0; i < getChildCount(); ++i) {
				Item item = (Item)getChildElement(i);
				int contentWidth = _font.getWidth(item.getLabel());
				if (contentWidth > maxContentWidth) maxContentWidth = contentWidth;
			}
			_width = _isMultiple ? maxContentWidth : maxContentWidth + SIZE_ARROW;
		}
		if (_width < SIZE_MINIMUM) _width = SIZE_MINIMUM;
		if (_height < _font.getHeight()) _height = _font.getHeight();
		if (_isMultiple) _height = (_height + _padding) * getChildCount() + (_margin + _border) * 2;
	}

	/* (non-Javadoc)
	 * @see jp.haw.grain.sprout.Renderer#draw(jp.haw.grain.sprout.DrawContext)
	 */
	public abstract void draw(DrawContext dc);
    
	/* (non-Javadoc)
	 * @see jp.haw.grain.sprout.InlineElement#action(int, int)
	 */
	public boolean handleAction(FormContext view, int action, int selector) {
		super.handleAction(view, action, selector);
		switch (action) {
			case FormContext.ACT_PRESSED:
				if (selector == FormContext.SEL_SELECT) {
					_pressed = true;
				} else {
					return false;
				}
				break;
			case FormContext.ACT_RELEASED:
				if (selector == FormContext.SEL_SELECT) {
					_pressed = false;
					if (_activate) {
						_activate = false;
						_selectionIndex = _currentIndex;
						if(this._isMultiple) {
							Integer index = new Integer(_selectionIndex);
							if(_selections.contains(index)) {
							   _selections.removeElement(index); 
							} else {
								_selections.addElement(index);
							}
						}
					} else {
						_activate = true;
						_currentIndex = _selectionIndex;
					}
					//TODO change dispatch mothod
					//this.element.dispatchEvent(new Event("DOMActivate", true, true));
				} else if (
					selector == FormContext.SEL_CANCEL
					|| selector == FormContext.SEL_RIGHT
					|| selector == FormContext.SEL_LEFT
					) {
					if (_activate) {
						_activate = false;
					}
				} else if (_activate && selector == FormContext.SEL_DOWN) {
					if (_currentIndex + 1 < getChildCount()) {
						_currentIndex++;
					}
				} else if (_activate && selector == FormContext.SEL_UP) {
					if (_currentIndex - 1 >= 0) {
						_currentIndex--;
					}
				} else {
					return false;
				}
				break;
		} 
		view.requestRender();
		return true;
	}


}
