/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/23 7:37:14
 * 
 */
package jp.grain.sprout.ui;

/**
 * TODO Choice
 * 
 * @version $Id: TabBlock.java 329 2006-05-26 11:38:28Z nakajo $
 * @author Go Takahashi
 */
public class TabBlock extends Block implements ActionHandler {

    public static final String NAME = "tab-bar";
    
    private static final int COLOR_BLACK = 0x000000; // 
    private static final int COLOR_BUTTON = 0x999999; // {^wi
    private static final int COLOR_EDGE_DARK = 0x333333; // {^GbW(Áj
    private static final int COLOR_EDGE_LIGHT = 0xCCCCCC; // {^GbW()
    private static final int COLOR_FOCUS = 0xFF6666; // {^IIF
    private static final int COLOR_FIELD = 0xFFFFFF; // wi
    private static final int SIZE_BORDER = 1;
    private static final int SIZE_MARGIN = 0;
    private static final int SIZE_PADDING = 2;

    private int _currentIndex = 0;
    private int _tabWidth;
    private int _tabHeight;
    
    public TabBlock() {
        super(NAME);
        _margin = SIZE_MARGIN;
        _border = SIZE_BORDER;
        _padding = SIZE_PADDING;
    }

    protected void applySelf(Form form) {
        super.applySelf(form);
        if ("upper".equals(getAttribute("tab"))) {
            form.registerNavigation(0, this);
            _tabHeight = Font.getDefaultFont().getHeight();
            int contentWidth = _border;
            for (int i = 0; i < getChildCount(); ++i) {
                Block block = (Block)getChildElement(i);
                Inline label = block.getLabel();
                if (_currentIndex < 0 && "true".equals(block.getAttribute("selected"))) {
                    _currentIndex = i;
                }
                label.apply(form);
                contentWidth += label.getBoxWidth() + _padding * 2 + _border;
                if (label.getBoxHeight() > _tabHeight) {
                    _tabHeight = label.getBoxHeight();
                }
            }
            if (contentWidth - (_border + _padding) * 2 > _width) {
                contentWidth = _width - (_padding * 2 + _border) * (getChildCount() - 1);
                _tabWidth = contentWidth / getChildCount();
            }
            _height += _tabHeight + _padding * 2 + _border;
        }
    }
    
    protected void applyChildren(Form form) {
        for (int i = 0; i < _children.size(); ++i) {
            Box box = (Box)_children.elementAt(_currentIndex);
            if (i == _currentIndex) {
                box.setRelativePosition(0, _height);
                box.apply(form);
                _height += box.getBoxHeight();                
            }
        }
    }
        
    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.Renderer#draw(jp.haw.grain.sprout.DrawContext)
     */
    public void draw(DrawContext dc) {
        dc = dc.createContext();
        int bgColor = dc.getColorByHex(getInheritedAttribute("background-color"));
        int x = _margin;
        int y = _margin;
        int outer = (_padding + _border) * 2;
        dc.setColor(DEFAULT_BG_COLOR);
        dc.fillRect(x, y, getBoxWidth() - _margin * 2, getBoxHeight() - _margin * 2);
        for (int i = 0; i < getChildCount(); ++i) { 
            Block block = (Block)getChildElement(i);
            System.out.println("TAB-BLOCK DRAW: block="+block.getClass().getName());
            
            int width = (_tabWidth > 0) ? _tabWidth : block.getLabel().getWidth();
            System.out.println("TAB-BLOCK DRAW: width end");
            int height = _tabHeight;
            if (i == _currentIndex) {
                dc.moveTo(x, y);
                dc.setColor((bgColor < 0) ? DEFAULT_BG_COLOR : bgColor);
            } else {
                dc.setColor(DEFAULT_BG_COLOR);
                height -= 1;
                dc.moveTo(x, y + 1);
            }
            int offset = i > 0 && i != _currentIndex ? _border : 0;
            dc.clipRect(offset, 0, width + outer - offset, height + outer);
            dc.fillRect(0, 0, width + outer, height + outer);
            dc.setColor(COLOR_BLACK);
            if (_border > 0) {
                dc.setColor(COLOR_EDGE_LIGHT);
                dc.drawLine(0, 0, width + outer - 1, 0);
                dc.setColor(COLOR_EDGE_DARK);
                dc.drawLine(width + outer - 1, 0, width + outer - 1, height + outer - 1);
            }
            if (getOwnerForm().isFocusingOn(this) && i == _currentIndex) {
                dc.setColor(COLOR_FOCUS);
                dc.drawLine(0, _border, width + _padding * 2, _border);
            }
            dc.setView(_border, _border);
            dc.clipRect(0, 0, width + _padding * 2, height + _padding * 2);
            dc.setView(_border + _padding, _border + _padding);
            dc.setColor(COLOR_BLACK);
            block.getLabel().draw(dc);
//            dc.drawString(block.getLabel(), 0, 0);
            x += width + outer - _border;
            dc.clearClip();
        }
        x = _margin;
        y = _margin + _tabHeight + outer;
        dc.moveTo(x, y);
        dc.setColor((bgColor < 0) ? DEFAULT_BG_COLOR : bgColor);
        dc.fillRect(0, 0, getBoxWidth() - x - _margin, getBoxHeight() - y - _margin);
        
        if (_currentIndex < 0) return;
        dc.moveTo(0,0);
        DrawContext childCtx = dc.createContext(getContentX(), getContentY());
        Box child = (Box)_children.elementAt(_currentIndex);
        child.draw(childCtx.moveTo(child.x, child.y));
    }
    
    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.InlineElement#action(int, int)
     */
    public boolean handleAction(FormContext view, int action, int selector) {
        switch (action) {
            case FormContext.ACT_RELEASED:
                if (selector == FormContext.SEL_RIGHT) {
                    if (_currentIndex + 1 < getChildCount()) {
                        _currentIndex++;
                    }
                    view.requestRefresh();
                    view.requestRender();
                } else if (selector == FormContext.SEL_LEFT) {
                    if (_currentIndex - 1 >= 0) {
                        _currentIndex--;
                    }
                    view.requestRefresh();
                    view.requestRender();
                } else {
                    return false;
                }
                break;
        } 
        return true;
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.ActionHandler#isCaptureEnable()
     */
    public boolean isCaptureEnable() {
        return true;
    }

}
