/* 
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/09 15:30:31
 * 
 */
package jp.grain.sprout.platform.doja;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;

import java.io.IOException;
import java.io.InputStream;

import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;

import jp.grain.spike.BinaryXMLParser;
import jp.grain.sprout.Initializer;
import jp.grain.sprout.OperetionListener;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.model.Instance;
import jp.grain.sprout.ui.Box;
import jp.grain.sprout.ui.CharactorSequence;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormBuilder;
import jp.grain.sprout.ui.FormContext;
import jp.grain.sprout.ui.Inline;
import jp.grain.sprout.ui.InlineBlock;

import org.xmlpull.v1.XmlPullParserException;

/**
 * A test of LayoutManager
 * @version $Id: FormViewImplTest.java 248 2006-04-09 16:14:47Z go $
 * @author Go Takahashi
 */
public class FormViewImplTest extends TestCase {

    private String name;
    private Form form = null;
    
    public FormViewImplTest() {
    }

    public FormViewImplTest(String name, TestMethod method) {
        super(name, method);
    }
    
    protected void setUp() throws Exception {
        this.name = null;
        //index.gbxml rev 150 06/01/28
        MockSproutApp app = new MockSproutApp("resource:///index.gbxml");
        app.start();
        FormContextImpl ctx = (FormContextImpl) app.getFormContext();
        ctx.getInitializer().join();
        form = ctx.getForm();
    }

    public void testPaintCanvas() {
        Inline element = ((InlineBlock)form.getRootBlock().getChildBox(1)).getRow(1).getChildInline(1);
        assertEquals("focus element class name: " + element.getClass().getName(), "jp.grain.sprout.ui.TextBox", element.getClass().getName());
    }
    
    public void testChildBox_0() {
        Inline element = ((InlineBlock)form.getRootBlock().getChildBox(0)).getRow(0).getChildInline(0);
        assertEquals("class name 0.0.0: " + element.getClass().getName(), "jp.grain.sprout.ui.CharactorSequence", element.getClass().getName());
        assertEquals("text value 0.0.0: " + ((CharactorSequence)element).toString(), "", ((CharactorSequence)element).getText());
        
        // Note : as of 01/23/06 getText of CharacterSequence returns null, instead, use toString().
        element = ((InlineBlock)form.getRootBlock().getChildBox(0)).getRow(0).getChildInline(1);
        assertEquals("class name 0.0.1: " + element.getClass().getName(), "jp.grain.sprout.ui.CharactorSequence", element.getClass().getName());
        assertEquals("text value 0.0.1: " + ((CharactorSequence)element).toString(), "", ((CharactorSequence)element).getText()); 

        assertEquals("attrib 0.0.1 - font-weight value", element.getAttributeName(0), "font-weight");
        assertEquals("attrib 0.0.1 - font-size value", element.getAttributeName(1), "font-size");
        
        element = ((InlineBlock)form.getRootBlock().getChildBox(0)).getRow(0).getChildInline(2);
        assertEquals("class name 0.0.2: " + element.getClass().getName(), "jp.grain.sprout.ui.CharactorSequence", element.getClass().getName());
        assertEquals("text value 0.0.2: " + ((CharactorSequence)element).toString(), "i", ((CharactorSequence)element).getText());
    }
    
    public void testChildBox_1() {
        Box box = form.getRootBlock().getChildBox(1);
        assertEquals("attrib 1.x.x - line-height value", box.getAttributeName(0), "line-height");
        
        Inline element = ((InlineBlock)form.getRootBlock().getChildBox(1)).getRow(0).getChildInline(0);
        assertEquals("class name 1.0.0: " + element.getClass().getName(), "jp.grain.sprout.ui.CharactorSequence", element.getClass().getName());
        assertEquals("text value 1.0.0: " + ((CharactorSequence)element).toString(), "悤", ((CharactorSequence)element).getText());
        assertEquals("attrib 1.0.0 - break value", element.getAttribute("break"), "true");
        
        element = ((InlineBlock)form.getRootBlock().getChildBox(1)).getRow(1).getChildInline(0);
        assertEquals("class name 1.1.0: " + element.getClass().getName(), "jp.grain.sprout.ui.CharactorSequence", element.getClass().getName());
        assertEquals("text value 1.1.0: " + ((CharactorSequence)element).toString(), "J[hԍF", ((CharactorSequence)element).getText());
        
        element = ((InlineBlock)form.getRootBlock().getChildBox(1)).getRow(1).getChildInline(1);
        assertEquals("class name 1.1.1: " + element.getClass().getName(), "jp.grain.sprout.ui.TextBox", element.getClass().getName());
        assertEquals("attrib 1.1.1 - width value", element.getAttribute("width"), "100");
        assertEquals("attrib 1.1.1 - inputmode value", element.getAttribute("inputmode"), "digits");
        assertEquals("attrib 1.1.1 - ref value", element.getAttribute("ref"), "card-code-input");
        assertEquals("attrib 1.1.1 - break value", element.getAttribute("break"), "true");
        
        element = ((InlineBlock)form.getRootBlock().getChildBox(1)).getRow(2).getChildInline(0);
        assertEquals("class name 1.2.0: " + element.getClass().getName(), "jp.grain.sprout.ui.Button", element.getClass().getName());
        
        element = ((InlineBlock)form.getRootBlock().getChildBox(1)).getRow(3).getChildInline(0);
        assertEquals("class name 1.3.0: " + element.getClass().getName(), "jp.grain.sprout.ui.CharactorSequence", element.getClass().getName());
        assertEquals("text value 1.3.0: " + ((CharactorSequence)element).toString(), "card-code : ", ((CharactorSequence)element).getText());
        
        element = ((InlineBlock)form.getRootBlock().getChildBox(1)).getRow(4).getChildInline(0);
        assertEquals("class name 1.4.0: " + element.getClass().getName(), "jp.grain.sprout.ui.CharactorSequence", element.getClass().getName());
        assertEquals("text value 1.4.0: " + ((CharactorSequence)element).toString(), "exp-year : ", ((CharactorSequence)element).getText());
        
        element = ((InlineBlock)form.getRootBlock().getChildBox(1)).getRow(5).getChildInline(0);
        assertEquals("class name 1.5.0: " + element.getClass().getName(), "jp.grain.sprout.ui.CharactorSequence", element.getClass().getName());
        assertEquals("text value 1.5.0: " + ((CharactorSequence)element).toString(), "exp-month : ", ((CharactorSequence)element).getText());
        
        element = ((InlineBlock)form.getRootBlock().getChildBox(1)).getRow(6).getChildInline(0);
        assertEquals("class name 1.6.0: " + element.getClass().getName(), "jp.grain.sprout.ui.CharactorSequence", element.getClass().getName());
        assertEquals("text value 1.6.0: " + ((CharactorSequence)element).toString(), "name : ", ((CharactorSequence)element).getText());
        
        //error occurs below: Not yet implemented
        //element = ((InlineBlock)form.getRootBlock().getChildBox(1)).getRow(7).getChildInline(0);
        //assertEquals("class name 1.7.0: " + element.getClass().getName(), "jp.grain.sprout.ui.CharactorSequence", element.getClass().getName());
        //assertEquals("text value 1.7.0: " + ((CharactorSequence)element).toString(), "profile-name : ", ((CharactorSequence)element).getText());
        
        // NOTE : re-arrange indexing when inline-group is implemented
        element = ((InlineBlock)form.getRootBlock().getChildBox(1)).getRow(7).getChildInline(0);
        assertEquals("class name 1.8.0: " + element.getClass().getName(), "jp.grain.sprout.ui.Button", element.getClass().getName());
        
        element = ((InlineBlock)form.getRootBlock().getChildBox(1)).getRow(7).getChildInline(1);
        assertEquals("class name 1.8.1: " + element.getClass().getName(), "jp.grain.sprout.ui.Button", element.getClass().getName());
        
        element = ((InlineBlock)form.getRootBlock().getChildBox(1)).getRow(8).getChildInline(0);
        assertEquals("class name 1.9.0: " + element.getClass().getName(), "jp.grain.sprout.ui.CharactorSequence", element.getClass().getName());
        assertEquals("text value 1.9.0: " + ((CharactorSequence)element).toString(), "card-code-input : ", ((CharactorSequence)element).getText());
    }
    
    public void testChildBox_2() {
        Box box = form.getRootBlock().getChildBox(2);
        assertEquals("attrib 2.x.x - hr value", box.getAttribute("hr"), "true");
    }
    
    public Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new FormViewImplTest("testPaintCanvas", new TestMethod() {
            public void run(TestCase tc) { ((FormViewImplTest)tc).testPaintCanvas(); }
        }));
        
        suite.addTest(new FormViewImplTest("testChildBox_0", new TestMethod() {
            public void run(TestCase tc) { ((FormViewImplTest)tc).testChildBox_0(); }
        }));
        
        suite.addTest(new FormViewImplTest("testChildBox_1", new TestMethod() {
            public void run(TestCase tc) { ((FormViewImplTest)tc).testChildBox_1(); }
        }));
        
        suite.addTest(new FormViewImplTest("testChildBox_2", new TestMethod() {
            public void run(TestCase tc) { ((FormViewImplTest)tc).testChildBox_2(); }
        }));
                
        return suite;
    }
    
    
    class MockSproutApp extends GrainApp {

        Throwable error;
        String defaultUri;
        
        MockSproutApp(String defaultUri) {
            setDefaultFormUrl(defaultUri);
            setDefaultFormLocation(DEFAULT_FORM_LOC_HTTP);
            _context = new MockFormContextImpl(this);
        }
        
        public void loadBasicPref() {
        }
        
        public FormContext getFormContext() {
            return _context;
        }
        
    }
    
    class MockFormContextImpl extends FormContextImpl {

        /**
         * @param app
         */
        MockFormContextImpl(GrainApp app) {
            super(app);
        }
                
        public SerializeOperation createSubmissionOperation(String url) {
            return new MockSubmissionOperation(url, this);
        }
        
        public SerializeOperation createExternalInstanceLoadOperation(Instance element) {
            return super.createExternalInstanceLoadOperation(element);
        }
    }
    
    class MockSubmissionOperation extends SerializeOperation {

        private String url;
        private Initializer initializer;
        private Form form;

        MockSubmissionOperation(String url, FormContext context) {
            this.url = url;
            this.initializer = new Initializer(context);
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.FormSerializeOperation#setListener(jp.grain.sprout.OperetionListener)
         */
        public void setListener(OperetionListener observer) {
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doExecute(javax.microedition.io.Connection)
         */
        protected void doExecute(Connection conn) throws Exception {
            InputStream is = null;
            try {
                is = ((InputConnection)conn).openInputStream();
                BinaryXMLParser parser = BinaryXMLParser.newInstance(is, "SJIS");
                FormBuilder builder = new FormBuilder(parser, getConnectionString(), true);
                builder.build();
                this.form = (Form)builder.getDocument();
            } catch (IOException e) {
                e.printStackTrace();
                throw e;
            } catch (XmlPullParserException e) {
                e.printStackTrace();
            } finally {
                if (is != null) is.close();
            }
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doCompletion()
         */
        protected void doCompletion() throws Exception {
            this.initializer.init(this.form);
            this.initializer.start();
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doException(java.lang.Exception)
         */
        protected void doException(Exception e) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#getConnectionString()
         */
        public String getConnectionString() {
            return url;
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#getMode()
         */
        public int getMode() {
            System.out.println("getMode : READ");
            return Connector.READ;
        }
        
    }
}
