#!/usr/bin/ruby
require 'webrick'
include WEBrick

s = HTTPServer.new( :Port => 8080 )

# HTTPServer#mount(path, servletclass)
#   When a request referring "/hello" is received,
#   the HTTPServer get an instance of servletclass
#   and then call a method named do_"a HTTP method".

class HelloServlet < HTTPServlet::AbstractServlet

	@@sessions = Hash.new
	
	def do_POST(req, res)
		def req.set_exheaders(exheaders)
			@exheaders = exheaders
			@exheaders.update(self.header)
		end
		def req.exheaders()
			return @exheaders
		end
		def req.init_session(id)
			if id == "request" || id == "response" then
				sid = Time.now.to_i + rand(Time.now.to_i)
				@session = {"id"=>sid, "direction"=>id}
				@@sessions.store(@session["id"].to_s, @session)
			else
				@session = @@sessions[id]
			end
		end
		def req.session()
			return @session
		end
		process_headers(req)
		process_divided_protocol(req, res)
	end
	
	def process_divided_protocol(req, res)
		req.init_session(req.exheaders["X-Divide-Session-ID"])
		if req.session == nil then
			req.init_session("request")
			if req.exheaders["X-Divide-Protocol-Version"] == "1.0" then
				req.session["max-count"] = req.exheaders["X-Divide-Max-Count"].to_i
				req.session["content-type"] = req.exheaders["X-Content-Type"]
			else
				req.session["content-type"] = req.exheaders["Content-Type"]
			end
		end
		if req.session["direction"] == "request" then
			puts "*** request ***"
			req.session.each{|key, value| if key == "data" then puts "data-length: #{value.length}" else puts "#{key} => #{value}" end }
			process_request(req, res)
		end
		if req.session["direction"] == "response" then
			puts "*** response ***"
			req.session.each{|key, value| if key == "data" then puts "data-length: #{value.length}" else puts "#{key} => #{value}" end }
			process_response(req, res)
		end
	end 
	
	def process_request(req, res)
		max = req.session["max-count"].to_i
		if max < 0 then
			res.status = 400
			return
		elsif max == 0 then
			max = 1
		elsif max == 1 then 
			puts "*** warning X-Divide-Max-Count is 1"
		end
		count = req.exheaders["X-Divide-Count"].to_i
		if count < 0 || count > max then
			res.status = 400
			return
		end
		if count == 0 then count = 1 end
		puts "===> request[#{count}]"
		if req.session["data"] == nil then
			req.session["data"] = Array.new(max)
		end
		req.session["data"][count - 1] = get_divided_body(req)
		req.session["last-count"] = count
		if count < max then
			res["Content-Type"] = "application/gbxml"
			res["X-Divide-Protocol-Version"] = "1.0"
			res["X-Divide-Session-ID"] = req.session["id"]
		else
			data = req.session["data"].join
			open("servlet.log", "w") {|f| f.write(data) }
			if data.length <= 20000 then
				res["Content-Type"] = req.session["content-type"]
				req.session["max-count"] = 1
				res.body = data
			else
				req.exheaders["X-Divide-Count"] = 0
				res["Content-Type"] = "application/gbxml"
				res["X-Content-Type"] = req.session["content-type"]
				req.init_session("response")
				req.session["data"] = data
				req.session["max-count"] = data.length / 20000 + (data.length % 20000 == 0 ? 0 : 1)
				req.session["content-type"] = res["X-Content-Type"]
			end
		end
	end

	def process_response(req, res)
		max = req.session["max-count"]
		if max == 1 then
			return
		end
		count = req.exheaders["X-Divide-Count"].to_i
		if count == 0 then count = 1 end
		puts "===> response[#{count}]"
		res["Content-Type"] = "application/gbxml"
		res["X-Divide-Protocol-Version"] = "1.0"
		res["X-Divide-Session-ID"] = req.session["id"]
		res["X-Divide-Count"] = count
		if count == max then
			res["X-Divide-Transfer"] = "end"
		elsif count == 1 then
			res["X-Divide-Transfer"] = "start"
		end
		if count == 1 then
			res["X-Divide-Max-Count"] = max
		end
		offset = 20000 * (count - 1)
		res.body = req.session["data"][offset, 20000]
		req.session["last-count"] = count
	end

	def process_headers(req)
		puts "*** extended headers ***"
		headers = Hash.new("")
		if req.content_type == "application/gbxml" then
			e = req.body.index("\n\n")
			req.body[0...e].scan(/^.*$/){|s|
				h = s.split(/:\s+/)
				headers.store(h[0], h[1])
			}
		end
		headers.each{|key, value| puts "#{key} => #{value}"}
		req.set_exheaders(headers)
	end

	def get_divided_body(req)
		s = req.body.index("\n\n");
		return req.body[s+2..-1]
	end
end

s.mount("/test", HelloServlet)

# HTTPServer#mount_proc(path){|req, res| ...}
#   You can mount also a block by `mount_proc'.
#   This block is called when GET or POST.

s.mount_proc("/hello/again"){|req, res|
	res.body = "<HTML>hello (again)</HTML>"
	res['Content-Type'] = "text/html"
}

trap("INT"){ s.shutdown }
s.start
