/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Item2Item
extends AbstractTransformer {
    protected GudBuilder builder;
    protected Element current;

    public Item2Item(GudBuilder builder) {
        this.builder = builder;
    }

    protected boolean isTarget(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        Element e = (Element)node;
        if (e.getNamespaceURI() != "http://www.w3.org/2002/xforms") {
            return false;
        }
        return e.getLocalName().equals("item");
    }

    public DocumentFragment transform() {
        Document dom = this.builder.getGudDoc();
        DocumentFragment df = dom.createDocumentFragment();
        Element xforms_item = (Element)this.node;
        Element gud_item = dom.createElementNS("http://grain.jp/gud/", "item");
        NodeList labels = Util.getNamedChildNode(xforms_item, "http://www.w3.org/2002/xforms", "label");
        NodeList values = Util.getNamedChildNode(xforms_item, "http://www.w3.org/2002/xforms", "value");
        Element gud_name = dom.createElementNS("http://grain.jp/gud/", "name");
        Element gud_value = dom.createElementNS("http://grain.jp/gud/", "value");
        if (labels.getLength() > 0 && labels.item(0).getTextContent() != null && !labels.item(0).getTextContent().equals("")) {
            gud_name.setTextContent(labels.item(0).getTextContent());
            gud_item.appendChild(gud_name);
        }
        if (values.getLength() > 0 && values.item(0).getTextContent() != null && !values.item(0).getTextContent().equals("")) {
            gud_value.setTextContent(values.item(0).getTextContent());
            gud_item.appendChild(gud_value);
        }
        this.registSkipList(labels);
        this.registSkipList(values);
        if (gud_item.getChildNodes().getLength() == 0) {
            this.current = null;
            return null;
        }
        df.appendChild(gud_item);
        this.current = null;
        return df;
    }

    protected void registSkipList(NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node skipNode = list.item(i);
            this.builder.addSkipNode(skipNode);
            NodeList childChildren = skipNode.getChildNodes();
            for (int j = 0; j < childChildren.getLength(); ++j) {
                this.builder.addSkipNode(childChildren.item(j));
            }
        }
    }

    public Element getCurrentElement() {
        return this.current;
    }
}

