/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform;

import java.util.List;
import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.transformer.Html2Form;
import jp.haw.grain.transform.util.NamespaceMap;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransformOperation {
    protected Document gudDoc;
    protected Element current;
    protected NamespaceMap rootNamespaceMap;
    protected AbstractTransformer transformer;
    protected int deep;

    public TransformOperation(Element element) {
        this.gudDoc = element.getOwnerDocument();
        this.current = element;
        this.deep = 0;
        this.rootNamespaceMap = new NamespaceMap(this.gudDoc.createElement("mapping_root"));
        this.rootNamespaceMap.addUriPrefix("http://grain.jp/gud/", "EMPTY_PREFIX");
    }

    public TransformOperation(Element element, NamespaceMap mapping, int deep) {
        this.gudDoc = element.getOwnerDocument();
        this.current = element;
        this.deep = deep;
        this.rootNamespaceMap = mapping;
    }

    public void operation(AbstractTransformer t) {
        this.transformer = t;
        DocumentFragment df = t.transform();
        if (t instanceof Html2Form) {
            this.registNamespaceMapping(this.gudDoc.getDocumentElement(), this.rootNamespaceMap);
        }
        NamespaceMap map = this.searchMapping(this.rootNamespaceMap, this.current);
        if (df != null) {
            int start = this.current.getChildNodes().getLength();
            this.current.appendChild(df);
            NodeList list = this.current.getChildNodes();
            int end = list.getLength();
            for (int i = start; i < end; ++i) {
                Node node = list.item(i);
                this.registNamespaceMapping(node, map);
                this.resolvePrefix(node);
            }
        }
    }

    protected void registNamespaceMapping(Node node, NamespaceMap currentNMap) {
        int i;
        if (node.getNodeType() == 3) {
            return;
        }
        if (currentNMap == null) {
            throw new RuntimeException("Namespace can not resolve: deep=" + this.deep + " node=" + node.getClass().getName() + "[" + node.getNodeName() + ": " + node.getNamespaceURI() + ": " + node.getNodeValue());
        }
        NamespaceMap nMap = new NamespaceMap(node);
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            for (i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                if (!attr.getNodeName().startsWith("xmlns")) continue;
                String uri = attr.getNodeValue();
                String prefix = null;
                if (attr.getNodeName().indexOf(":") == -1) {
                    prefix = "EMPTY_PREFIX";
                } else {
                    String name = attr.getNodeName();
                    prefix = name.substring(name.indexOf(":") + 1);
                }
                nMap.addUriPrefix(uri, prefix);
            }
        }
        currentNMap.addChild(nMap);
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList list = node.getChildNodes();
        for (i = 0; i < list.getLength(); ++i) {
            this.registNamespaceMapping(list.item(i), nMap);
        }
    }

    protected NamespaceMap searchMapping(NamespaceMap mapping, Node node) {
        NamespaceMap searchMapping = null;
        if (mapping.getOwnerNode().equals(node)) {
            return mapping;
        }
        if (!mapping.hasChildren()) {
            return null;
        }
        List children = mapping.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            NamespaceMap child = (NamespaceMap)children.get(i);
            searchMapping = this.searchMapping(child, node);
        }
        return searchMapping;
    }

    protected void resolvePrefix(Node node) {
        if (node.getNodeType() == 3) {
            return;
        }
        String uri = node.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        String prefix = this.resolvePrefix(uri, this.searchMapping(this.rootNamespaceMap, node));
        if (node.getNodeType() == 1) {
            if (prefix != null && !prefix.equals(node.getPrefix())) {
                node.setPrefix(prefix);
            } else if (node.getPrefix() != null && node.getPrefix().equals(prefix)) {
                node.setPrefix(prefix);
            }
        }
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.resolvePrefix(children.item(i));
        }
    }

    protected String resolvePrefix(String uri, NamespaceMap mapping) {
        if (mapping == null) {
            return null;
        }
        if (mapping.contains(uri)) {
            return mapping.getPrefix(uri);
        }
        if (mapping.getParent() == null) {
            return null;
        }
        return this.resolvePrefix(uri, mapping.getParent());
    }

    public TransformOperation createChildNodeOperation() {
        if (this.transformer == null) {
            return new TransformOperation(this.current, this.rootNamespaceMap, this.deep);
        }
        Element child = this.transformer.getCurrentElement();
        if (child == null) {
            return new TransformOperation(this.current, this.rootNamespaceMap, this.deep);
        }
        return new TransformOperation(child, this.rootNamespaceMap, this.deep + 1);
    }

    public Node getCurrentNode() {
        return this.current;
    }

    public String toString() {
        return '@' + Integer.toHexString(this.hashCode()) + "[" + this.current.getNodeName() + "]";
    }

    public NamespaceMap getRootMap() {
        return this.rootNamespaceMap;
    }
}

