package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.TransformOperation;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author nakajo
 */
public class P2InlineBlockTest extends TestCase {
	
	/**
	 * bodyvf̎qvfłp^OϊΏۂƂȂB
	 *
	 */
	public void testSimpleTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "body", null);
		Element body = simpleDoc.getDocumentElement();
		Element p = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		Element span = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		Element p2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		
		body.appendChild(p);
		p.appendChild(span);
		span.appendChild(p2);
		
		P2InlineBlock p2inb = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);
				
				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "inline-block"); 
				assertTrue("current is null check", t.getCurrentElement() != null);
			}
		};

		p2inb.apply(p, mockOperation);
		p2inb.apply(p2, mockOperation);
	}

	/**
	 * bodyvf̎qvfłp^OϊΏۂƂȂB
	 * Rs[
	 *
	 */
	public void testAttrsCopy() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "body", null);
		Element body = simpleDoc.getDocumentElement();
		Element p = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		p.setAttribute("ev:event", "DOMActivate");
		p.setAttribute("id", "hog1");
		p.setAttribute("padding", "2px");
		
		Element span = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		
		Element p2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		p2.setAttribute("ev:event", "DOMActivate");
		p2.setAttribute("id", "hog1");
		p2.setAttribute("padding", "2px");
		
		body.appendChild(p);
		p.appendChild(span);
		span.appendChild(p2);
		
		P2InlineBlock p2inb = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);
				
				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "inline-block"); 
				assertTrue("current is null check", t.getCurrentElement() != null);

				NamedNodeMap attrs = node.getAttributes();
				assertEquals("attrs length check", attrs.getLength(), 3);
				Node event = attrs.getNamedItem("ev:event");
				Node id = attrs.getNamedItem("id");
				Node padding = attrs.getNamedItem("padding");
				
				assertTrue("event not null check", event != null);
				assertTrue("id not null check", id != null);
				assertTrue("padding not null check", padding != null);

				assertEquals("event same value check", event.getNodeValue(), "DOMActivate");
				assertEquals("id same value check", id.getNodeValue(), "hog1");
				assertEquals("padding same value check", padding.getNodeValue(), "2px");
			}
		};

		p2inb.apply(p, mockOperation);
		p2inb.apply(p2, mockOperation);
	}



	/**
	 * localnamepȂ̂ŕϊΏۂɂȂȂ
	 *
	 */
	public void testNotXFormsTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "body", null);
		Element body = simpleDoc.getDocumentElement();
		Element p = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		Element span = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		Element p2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		
		body.appendChild(p);
		p.appendChild(span);
		span.appendChild(p2);
		
		P2InlineBlock p2inb = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		p2inb.apply(span, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	/**
	 * c悪bodyȂ̂ŕϊΏۂɂȂȂB
	 *
	 */
	public void testNotBodyParent() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "html", null);
		Element body = simpleDoc.getDocumentElement();
		Element p = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		Element span = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		Element p2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		
		body.appendChild(p);
		p.appendChild(span);
		span.appendChild(p2);
		
		P2InlineBlock p2inb = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		p2inb.apply(p, mockOperation);
		mockOperation.createChildNodeOperation();
		p2inb.apply(p2, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	/**
	 * NSXHTMLȂ̂ŕϊΏۂɂȂȂB
	 *
	 */
	public void testWrongNS() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "body", null);
		Element body = simpleDoc.getDocumentElement();
		String testNS = "http://grain.jp/test/";
		
		Element p = simpleDoc.createElementNS(testNS, "p");
		Element span = simpleDoc.createElementNS(testNS, "span");
		Element p2 = simpleDoc.createElementNS(testNS, "p");
		
		body.appendChild(p);
		p.appendChild(span);
		span.appendChild(p2);
		
		P2InlineBlock p2inb = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		p2inb.apply(p, mockOperation);
		mockOperation.createChildNodeOperation();
		p2inb.apply(p2, mockOperation);
		mockOperation.createChildNodeOperation();
	}
	
	
	class MockTransformer extends P2InlineBlock {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, boolean targetResult) {
			super(builder);
			this.targetResult = targetResult;
		}
		
		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}
}
