package jp.haw.grain.transform.xpath;

import java.io.IOException;
import java.io.StringWriter;

import jp.haw.grain.transform.GudBuilder;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPathExprCompilerTest extends TestCase {

	public void testSampleCompile() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument(GudBuilder.GUD_NS, "exprRoot", null);

		String xpath = "/a/b[position()=2]";
		try {
			Element exprRoot = gudDoc.getDocumentElement();
			
			XPathExprCompiler compiler = new XPathExprCompiler();
			exprRoot.appendChild(compiler.compile(xpath, gudDoc));

			assertEquals(sampleResult, doc2String(gudDoc));
		} catch (Exception e) {
			fail("Exception"+e.toString());
		}
	}

	public void testNamteTestOnly() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument(GudBuilder.GUD_NS, "exprRoot", null);

		String xpath = "hoge";
		try {
			Element exprRoot = gudDoc.getDocumentElement();
			
			XPathExprCompiler compiler = new XPathExprCompiler();
			exprRoot.appendChild(compiler.compile(xpath, gudDoc));

			assertEquals(nameTestOnlyResult, doc2String(gudDoc));
		} catch (Exception e) {
			fail("Exception"+e.toString());
		}
	}

	public void testSimplePredicate() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument(GudBuilder.GUD_NS, "exprRoot", null);

		String xpath = "hoge[2]";
		try {
			Element exprRoot = gudDoc.getDocumentElement();
			
			XPathExprCompiler compiler = new XPathExprCompiler();
			exprRoot.appendChild(compiler.compile(xpath, gudDoc));

			assertEquals(simplePredicateResult, doc2String(gudDoc));
		} catch (Exception e) {
			fail("Exception"+e.toString());
		}
	}
	
	public void testCalc() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument(GudBuilder.GUD_NS, "exprRoot", null);

		String xpath = "1 + 2 * 3 - 4 div 5";
		try {
			Element exprRoot = gudDoc.getDocumentElement();
			
			XPathExprCompiler compiler = new XPathExprCompiler();
			exprRoot.appendChild(compiler.compile(xpath, gudDoc));

			assertEquals(calcResult, doc2String(gudDoc));
		} catch (Exception e) {
			fail("Exception"+e.toString());
		}
	}
	
	private String doc2String(Document doc) throws IOException {
		StringWriter out = new StringWriter();
		
		//o̓tH[}bg̎w
		OutputFormat formatter = new OutputFormat();
		//󔒕̕ۑ
		formatter.setPreserveSpace(true);
		formatter.setIndenting(false);
		formatter.setOmitXMLDeclaration(true);
		formatter.setEncoding("Shift_JIS");
		//XMLSerializer ̍쐬
		XMLSerializer serializer = new XMLSerializer(out, formatter);

		serializer.serialize(doc);
		return out.toString();
	}

	public static final String sampleResult = 
		"<exprRoot>" +
			"<xpath:expr>" +
				"<xpath:clspush>" +
					"<xpath:ctxpload _0=\"1\"/>" +
					"<xpath:N2/>" +
					"<xpath:eq/>" +
				"</xpath:clspush>" +
				"<xpath:_child/>" +
				"<xpath:_child/>" +
				"<xpath:_absolute/>" +
				"<xpath:ctxnload/>" +
				"<xpath:step _0=\"\" _1=\"\"/>" +
				"<xpath:step _0=\"a\" _1=\"\"/>" +
				"<xpath:step _0=\"b\" _1=\"\"/>" +
				"<xpath:filter/>" +
			"</xpath:expr>" +
		"</exprRoot>";

	public static final String nameTestOnlyResult = 
		"<exprRoot>" +
			"<xpath:expr>" +
				"<xpath:_child/>" +
				"<xpath:ctxnload/>" +
				"<xpath:step _0=\"hoge\" _1=\"\"/>" +
			"</xpath:expr>" +
		"</exprRoot>";

	public static String simplePredicateResult = 
		"<exprRoot>" +
			"<xpath:expr>" +
				"<xpath:clspush>" +
					"<xpath:ctxpload _0=\"1\"/>" +
					"<xpath:N2/>" +
					"<xpath:eq/>" +
				"</xpath:clspush>" +
				"<xpath:_child/>" +
				"<xpath:ctxnload/>" +
				"<xpath:step _0=\"hoge\" _1=\"\"/>" +
				"<xpath:filter/>" +
			"</xpath:expr>" +
		"</exprRoot>";
	
	public static String calcResult = 
		"<exprRoot>" +
			"<xpath:expr>" +
				"<xpath:N1/>" +
				"<xpath:N2/>" +
				"<xpath:N3/>" +
				"<xpath:mult/>" +
				"<xpath:add/>" +
				"<xpath:N4/>" +
				"<xpath:N5/>" +
				"<xpath:div/>" +
				"<xpath:sub/>" +
			"</xpath:expr>" +
		"</exprRoot>";
}
