/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/21 22:53:29
 * 
 */
package jp.grain.spike;

import java.util.Hashtable;

import jp.grain.spike.event.Event;

/**
 * TODO DefaultElement
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class DefaultElement extends Element {

	public static final String XSD_ID = "id";

    /**
     * @param name
     */
    public DefaultElement(String name) {
        super(name);
    }

    public DefaultElement(String name, String prefix, String namespace) {
        super(name, prefix, namespace);
    }
    
    /* (non-Javadoc)
     * @see jp.grain.spike.Node#preProcess(jp.grain.spike.Node)
     */
    public void preProcess(Node parent) {
        if (parent instanceof Element) {
        	((Element)parent).addChild(this);
        } else if (parent instanceof Document) {
            ((Document)parent).setRootElement(this);
        }
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Node#postProcess(jp.grain.spike.Node)
     */
    public void postProcess(Node parent) {
        // nothing to do
    }
    
    public Node clone(Document doc) {
        Element elem = createElement();
        if (_attributes != null) {
            for (int i = 0; i < _attributes.size(); ++i) {
                Attribute src = (Attribute)_attributes.elementAt(i);
                if (XSD_ID.equals(src._name) && src._namespace == null) {
                    doc.registerNode(src._value, elem);
                }
                elem.addAttribute(src._name, src._prefix, src._namespace, src._value);
            }
        }
        for (int i = 0; i < getChildCount(); ++i) {
            Object child = getChild(i);
            if (child instanceof Node) {
                elem.addChild(((Node)child).clone(doc));
            } else if (child instanceof String) {
                elem.setText((String)child);
            }
        }
        return elem;
    }
        
    protected Element createElement() {
        return new DefaultElement(_name, _prefix, _namespace);    
    }

    public int getNodeType() {
		return Node.NODE_TYPE_ELEMENT;
	}

}
