/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/02/05
 * 
 */
package jp.grain.sprout.platform.doja;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.microedition.io.Connection;

import jp.grain.spike.BinaryXMLParser;
import jp.grain.spike.BinaryXMLSerializer;
import jp.grain.spike.Document;
import jp.grain.spike.Node;
import jp.grain.sprout.Initializer;
import jp.grain.sprout.model.Instance;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormBuilder;
import jp.grain.sprout.ui.FormContext;

import org.xmlpull.v1.XmlPullParserException;

/**
 * HTTPoR̃tH[MIy[V
 * 
 * @version $Id: FormSubmissionOperation.java 235 2006-04-09 03:17:09Z go $
 * @author Go Takahashi
 */
class FormSubmissionOperation extends HttpPostOperation {

	private Node _node;
    private Instance _instance;
    private Document _doc;
    private Initializer _initializer;

	FormSubmissionOperation(FormContext context, String uri, Node node) {
        super(uri, "application/gbxml");
        _initializer = new Initializer(context);
        _node = node;
	}
    
    FormSubmissionOperation(FormContext context, Instance instance, String uri, Node node) {
        this(context, uri, node);
        _instance = instance;
        _node = node;
    }
        
    protected void doExecute(Connection conn) throws Exception {
        if (_instance == null) {
            DividedHttpConnection dhc = (DividedHttpConnection)conn;
            dhc.setRequestProperty(DividedHttpConnection.HEADER_X_EXPECT_FO, "gud");
        }
        
        super.doExecute(conn);        
    }
    /* (non-Javadoc)
     * @see jp.grain.sprout.platform.doja.HttpPostOperation#writeRequest(java.io.OutputStream)
     */
    protected void writeRequest(OutputStream os) throws IOException {
        if (_node == null) return;
        BinaryXMLSerializer bxs = new BinaryXMLSerializer(_node);
        bxs.serializeTo(os);
    }    
    
    /* (non-Javadoc)
     * @see jp.grain.sprout.platform.doja.HttpPostOperation#readResponse(java.io.InputStream)
     */
    protected void readResponse(InputStream is) throws IOException, XmlPullParserException {
        boolean gud = (_instance == null);
        FormBuilder builder = new FormBuilder(BinaryXMLParser.newInstance(is, "SJIS"), _uri, gud);
        builder.build();
        _doc = (Form)builder.getDocument();
        System.out.println("get document : doc = " + _doc);        
    }

    protected void doCompletion() throws Exception {
        System.out.println("do completion :");
        System.out.println("_instance = " + _instance);
        System.out.println("_doc = " + _doc);
        if (_instance == null) {
            _initializer.init((Form)_doc);
        } else {
            _initializer.init(_instance, _doc);
        }
        _initializer.start();
    }

    protected void doException(Exception e) {
        FormContext ctx = _initializer.getContext();
        if (e instanceof IOException) {
            ctx.showErrorDialog("ʐMG[ɂtH[̎擾Ɏs܂B\n{ݒmFĂB\n", e);
        } else if (e instanceof XmlPullParserException) {
            ctx.showErrorDialog("擾tH[̉͂͂ł܂B\n", e);
        } else {
            ctx.showErrorDialog("\ȂG[ɂ菉Ɏs܂B", e);
        }
    }


}