/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/08/12 20:07:00 
 */
package jp.grain.sprout.ui;

/**
 * TextBox
 * 
 * @version $Id: Label.java 347 2006-06-08 13:51:39Z nakajo $
 * @author Go Takahashi
 */
public class Label extends InlineComponent {

    private static final int COLOR_BLACK = 0x000000; // 
    private static final int COLOR_FIELD = 0xFFFFFF; // wi
    private static final int COLOR_EDGE_DARK = 0x333333; // GbW(Áj
    private static final int COLOR_EDGE_LIGHT = 0xCCCCCC; // GbW()
    private static final int COLOR_FOCUS = 0xFF6666; // IIF
    private static final int SIZE_MINIMUM = 3;
            
    /**
     * 
     */
    public Label() {
        super("label");
    }
    
    public void apply(Form form) {
        form.registerNavigation(getNavigationIndex(), this);
        if (this._width < SIZE_MINIMUM) {
            String text = getBindingSimpleContent();
            this._width = Font.getDefaultFont().getWidth(text);
        }
        if (this._height < SIZE_MINIMUM)
            this._height = Font.getDefaultFont().getHeight();
    }

    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.Renderer#draw(jp.haw.grain.sprout.DrawContext)
     */
    public void draw(DrawContext dc) {
        drawCommonStyle(dc);
        String text = getBindingSimpleContent();
        dc.clipRect(this._margin, this._margin, getBoxWidth() - this._margin * 2, getBoxHeight() - this._margin * 2);
        dc.drawString((text != null) ? text : "", getContentX(), getContentY() + (getHeight() - Font.getDefaultFont().getHeight()) / 2);
    }

    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.InlineElement#action(int, int)
     */
    public boolean action(FormContext view, int action, int selector) {
        return false;
    }

}
