/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/17 16:19:22
 * 
 */
package jp.grain.sprout.model;

import java.io.IOException;
import java.util.Vector;

import jp.grain.spike.DefaultElement;
import jp.grain.spike.Element;
import jp.grain.spike.Node;
import jp.grain.spike.event.Event;
import jp.grain.spike.event.EventListener;
import jp.grain.sprout.ui.ContextNodeset;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormBuilder;
import jp.grain.sprout.ui.FormContext;


/**
 * TODO Model
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Model extends DefaultElement implements EventListener {
    
    public static final String NAME = "model";
    private Vector _instances = new Vector();
    private Vector _binds = new Vector();
    private Vector _submissions = new Vector();
    
    public Model() {
        super(NAME);
    }
    
    /**
     * @throws IOException 
     * 
     */
    public void init(FormContext context) throws IOException {
		System.out.println("TESTCASE: Model.init()");
        for (int i = 0; i < _instances.size(); ++i) {
            Instance instance = (Instance)_instances.elementAt(i);
            if (instance == null) continue;
			instance.init(context);
        }
        for (int i = 0; i < _binds.size(); ++i) {
        	Bind bind = (Bind)_binds.elementAt(i);
            if (bind == null) continue;
            bind.init(context.getForm());
            bind.reBuild();
            bind.bindingProperty();
        }
        for (int i = 0; i < _submissions.size(); ++i) {
            Submission submission = (Submission)_submissions.elementAt(i);
            if (submission == null) continue;
            submission.init(context.getForm());
        }
    }
    
    /* (non-Javadoc)
     * @see jp.grain.spike.Element#getText()
     */
    public String getText() {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Element#getChildText(int)
     */
    public String getChildText(int index) {
        // TODO Auto-generated method stub
        return null;
    }

    /**
     * 
     */
    public void rebuild() {
        Event ev = new Event("xforms-rebuild", true, false);
        dispatchEvent(ev);
        if (ev.isPreventDefault()) return;
        // default action - rebuild computational dependency data structure
        // use preproccessor ?
    }

    /**
     * 
     */
    public void recalculate() {
        Event ev = new Event("xforms-recalcutate", true, false);
        dispatchEvent(ev);
        if (ev.isPreventDefault()) return;
        // default action - recalculate using dependency data structure
        // use preproccessor ?
    }

    /**
     * 
     */
    public void revalidate() {
        Event ev = new Event("xforms-revalidate", true, false);
        dispatchEvent(ev);
        if (ev.isPreventDefault()) return;
        // default action - required and constraint...and so on... are checked
        // and notify that's result.
    }

    /**
     * @return
     */
    public ContextNodeset getContextNodeset() {
        Vector elements = ((Form)getParent()).getBindingElements();
        for (int i = elements.size() - 1; i >= 0; --i) {
            ContextNodeset ctxNodeset = (ContextNodeset)elements.elementAt(i);
            if (ctxNodeset.getModel() == this) {
                return ctxNodeset;
            }
        }
        for (int i = 0; i < getChildCount(); ++i) {
            Element element = (Element)getChildElement(i);
            if (element instanceof Instance) {
                return new ContextNodeset(this, ((Instance)element).getRootElement());            
            }
        }
        return null;
    }
    
    public void preProcess(Node parent) {
        if (parent instanceof Form) {
            ((Form)parent).addModel(this);
        }
    }

    /**
     * 
     */
    public static void init() {
        FormBuilder.registerComponent(NAME, new Model().getClass());
    }
    
    public Instance getInstanceBy(Node node) {
        for (int i = 0; i < _instances.size(); ++i) {
            Instance instance = (Instance)_instances.elementAt(i);
            if (instance.contains(node)) return instance;
        }
        return null;
    }
    
    /**
     * ̃f̎instanceԂ܂B
     * K擪instanceԂ܂Binstance1Ȃꍇ
     * nullԂ܂B
     * 
     * AXPath̉ꎟAK؂ȃ\bhɒu܂B
     * @TODO XPathK؂instanceTĕԂ\bh̍쐬
     * @return
     */
    public Instance getInstance() {
    	if(_instances.size() > 0 ) return (Instance)_instances.elementAt(0);
    	return null;
    }
    /**
     * @param instance
     */
    public void addInstance(Instance instance) {
        _instances.addElement(instance);
    }
    
    /**
     * modelŒ`Ăbindvfo^܂B
     * @param bind
     */
    public void addBind(Bind bind) {
    	_binds.addElement(bind);
    	bind.setParent(this);
    }
    
    public void addSubmission(Submission submission) {
    	_submissions.addElement(submission);
    	submission.setParent(this);
    }
    
    public boolean dispatchEvent(Event event) {
    	return handleEvent(event);
    	/**
        System.out.println("event name=" + event.getType());
        for (int i = 0; i < getChildCount(); ++i) {
            DefaultElement elem = (DefaultElement)getChildElement(i);
            if (elem == null) continue;
            String ev = elem.getAttribute("event", Event.NAME_SPACE);
            System.out.println("child name=" + elem.getName() + ",ev=" + ev);
            if (ev != null && event.getType().equals(ev)) {
                elem.dispatchEvent(event);
            }
        }
        */
    }


	public String[] getHandleEvents() {
		String[] events = new String[9];
		//4.2 Cxg
		events[0] = Event.TYPE_XFORMS_MODEL_CONSTRUCT;
		events[1] = Event.TYPE_XFORMS_MODEL_CONSTRUCT_DONE;
		events[2] = Event.TYPE_XFORMS_READY;
		events[3] = Event.TYPE_XFORMS_MODEL_DESTRUCT;
		//4.3 ݍpCxg
		events[4] = Event.TYPE_XFORMS_REBUILD;
		events[5] = Event.TYPE_XFORMS_REFRESH;
		events[6] = Event.TYPE_XFORMS_REVALIDATE;
		events[7] = Event.TYPE_XFORMS_RECALCULATE;
		events[8] = Event.TYPE_XFORMS_RESET;
		return events;
	}

	public boolean handleEvent(Event event) {
		System.out.println("HANDLE: Model.handleEvent() event="+event.getType());
		if(event.getType() == Event.TYPE_XFORMS_MODEL_CONSTRUCT) {
			//4.2.1-1 , 4.2.1-2
			System.out.println("TESTCASE: Model.init()");
	        for (int i = 0; i < _instances.size(); ++i) {
	            Instance instance = (Instance)_instances.elementAt(i);
	            if (instance == null) continue;
				instance.init(event.getContext());
	        }
	        for (int i = 0; i < _submissions.size(); ++i) {
	            Submission submission = (Submission)_submissions.elementAt(i);
	            if (submission == null) continue;
	            submission.init((Form)getDocument());
	        }
			
	        //4.2.1-3 not implements
	        //4.2.1-4
	        for (int i = 0; i < _binds.size(); ++i) {
	        	Bind bind = (Bind)_binds.elementAt(i);
	            if (bind == null) continue;
	            bind.init((Form)getDocument());
	            bind.bindingProperty();
	        }
	        Event construct = new Event(Event.TYPE_XFORMS_REBUILD, this, event, true, true);
            //4.2.1-5 xforms-rebuild
            handleEvent(construct);
            //4.2.1-5 xforms-rebuild
            construct.setType(Event.TYPE_XFORMS_RECALCULATE);
            handleEvent(construct);
            //4.2.1-5 xforms-revalidate
            construct.setType(Event.TYPE_XFORMS_REVALIDATE);
            handleEvent(construct);
	        
		} else if(event.getType() == Event.TYPE_XFORMS_MODEL_CONSTRUCT_DONE) {

		} else if(event.getType() == Event.TYPE_XFORMS_READY) {
		} else if(event.getType() == Event.TYPE_XFORMS_MODEL_DESTRUCT) {
		} else if(event.getType() == Event.TYPE_XFORMS_REBUILD) {
	        for (int i = 0; i < _binds.size(); ++i) {
	        	Bind bind = (Bind)_binds.elementAt(i);
	            if (bind == null) continue;
	            bind.init((Form)getDocument());
	            bind.reBuild();
	        }
		} else if(event.getType() == Event.TYPE_XFORMS_REFRESH) {
		} else if(event.getType() == Event.TYPE_XFORMS_REVALIDATE) {
	        for (int i = 0; i < _binds.size(); ++i) {
	        	Bind bind = (Bind)_binds.elementAt(i);
	            if (bind == null) continue;
	            bind.init((Form)getDocument());
	            reValidate(bind, event);
	        }
		} else if(event.getType() == Event.TYPE_XFORMS_RECALCULATE) {
	        for (int i = 0; i < _binds.size(); ++i) {
	        	Bind bind = (Bind)_binds.elementAt(i);
	            if (bind == null) continue;
	            bind.init((Form)getDocument());
	            bind.reCalculate();
	        }
		} else if(event.getType() == Event.TYPE_XFORMS_RESET) {
		}
		return false;
	}

	/**
	 * 4.3.5 xforms-revalidateCxg
	 * @param bind
	 * @param event
	 */
	protected void reValidate(Bind bind, Event event) {
		Event propetyChange = new Event(null, bind, event, true, false);
		boolean property = bind.isReadonly();
		bind.checkReadonly();
		if(property != bind.isReadonly()) {
			//4.3.5-3
			propetyChange.setType(bind.isReadonly() ? Event.TYPE_XFORMS_READONLY: Event.TYPE_XFORMS_READWRITE);
			((Form)getParent()).notifyEvent(propetyChange);
		}
		
		property = bind.isRequired();
		bind.checkRequired();
		if(property != bind.isRequired()) {
			//4.3.5-3
			propetyChange.setType(bind.isRequired() ? Event.TYPE_XFORMS_REQUIRED: Event.TYPE_XFORMS_OPTIONAL);
			((Form)getParent()).notifyEvent(propetyChange);
		}
		
		property = bind.isRelevant();
		bind.checkRelevant();
		if(property != bind.isRelevant()) {
			System.out.println("NOTIFY: model.reValidate() relevant change :"+bind.isRelevant());
			//4.3.5-3
			propetyChange.setType(bind.isRelevant() ? Event.TYPE_XFORMS_ENABLED: Event.TYPE_XFORMS_DISABLED);
			((Form)getParent()).notifyEvent(propetyChange);
		}
		
		property = bind.isConstraint();
		bind.checkConstraint();
		if(property != bind.isConstraint()) {
			//4.3.5-3
			propetyChange.setType(bind.isConstraint() ? Event.TYPE_XFORMS_VALID: Event.TYPE_XFORMS_INVALID);
			((Form)getParent()).notifyEvent(propetyChange);
		}
	}
}
