/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.divide;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import jp.haw.grain.divide.DataFolder;
import jp.haw.grain.divide.DividedData;
import org.apache.log4j.Logger;

public class ReadFolder
implements DataFolder,
Serializable {
    private static final Logger log = Logger.getLogger(ReadFolder.class);
    protected int mode;
    protected String sessionId;
    protected int index;
    protected long createTime;
    protected long survivalTime;
    protected DividedData[] dataList;
    protected String contentType;

    public ReadFolder(String sessionId, int maxCount) {
        this(sessionId, maxCount, null);
    }

    public ReadFolder(String sessionId, int maxCount, String contentType) {
        this.sessionId = sessionId;
        this.dataList = new DividedData[maxCount];
        this.mode = 1;
        this.createTime = Calendar.getInstance().getTimeInMillis();
        this.survivalTime = 1800000L;
        this.index = 0;
        if (contentType == null) {
            this.contentType = "plain/text";
        }
    }

    public DividedData getDataAt(int no) {
        for (int i = 0; i < this.dataList.length; ++i) {
            if (this.dataList[i].getNo() != no) continue;
            return this.dataList[i];
        }
        return null;
    }

    public void addData(DividedData data) {
        log.debug((Object)("addDivideData: length=" + data.getData().length));
        for (int i = 0; i < this.dataList.length; ++i) {
            if (this.dataList[i] == null || this.dataList[i].getNo() != data.getNo()) continue;
            this.dataList[i] = data;
            return;
        }
        this.dataList[this.index] = data;
        ++this.index;
        log.debug((Object)"addData: END");
    }

    public DividedData[] getDataList() {
        return this.dataList;
    }

    public int getMaxCount() {
        return this.dataList.length;
    }

    public int getMode() {
        return this.mode;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        List<DividedData> sortedData = Arrays.asList(this.dataList);
        Collections.sort(sortedData);
        for (DividedData dData : sortedData) {
            out.write(dData.getData());
        }
        out.close();
        return out.toByteArray();
    }

    public boolean isSurvival() {
        long nowTime = Calendar.getInstance().getTimeInMillis();
        return nowTime <= this.createTime + this.survivalTime;
    }

    public void setSurvivalTime(long l) {
        this.survivalTime = l;
    }

    public long getSurvivalTime() {
        return this.survivalTime;
    }

    public String getContentType() {
        return this.contentType;
    }
}

