/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.xpath;

import java.util.Set;
import java.util.TreeSet;
import jp.haw.grain.dom.ElementWrapper;
import jp.haw.grain.xpath.XPathByteCodeElementInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPathByteCodeElement
extends ElementWrapper
implements XPathByteCodeElementInterface {
    public static final int CONTEXT_PARAM_SIZE = 0;
    public static final int CONTEXT_PARAM_POSITION = 1;
    public static final String XPATH_EXPR_ROOT_NODE_NAME = "xpath:expr";
    public static final String AXIS_ABSOLUTE = "absolute";
    public static final String AXIS_SELF = "self";
    public static final String AXIS_CHILD = "child";
    public static final String AXIS_PARENT = "parent";
    public static final String AXIS_ANCESTOR = "ancestor";
    public static final String AXIS_FOLLOWING = "following";
    public static final String AXIS_PRECEDING = "preceding";
    public static final String AXIS_ATTRIBUTE = "attribute";
    public static final String AXIS_NAMESPACE = "namespace";
    public static final String AXIS_DESCENDANT = "descendant";
    public static final String AXIS_ANCESTOR_OR_SELF = "ancestor-or-self";
    public static final String AXIS_DESCENDANT_OR_SELF = "descendant-or-self";
    public static final String AXIS_FOLLOWING_SIBLING = "following-sibling";
    public static final String AXIS_PRECEDING_SIBLING = "preceding-sibling";
    public static final Set AXIS_MAP = new TreeSet();
    public static final String FUNC_POSITION = "position";
    public static final String FUNC_LAST = "last";
    public static final String FUNC_NUMBER = "number";
    public static final String FUNC_STRING = "string";
    public static final String FUNC_BOOLEAN = "boolean";
    public static final String FUNC_COUNT = "count";
    public static final String FUNC_ID = "id";
    public static final String FUNC_CONCAT = "concat";
    public static final String FUNC_STARTS_WITH = "starts-with";
    public static final String FUNC_CONTAINS = "contains";
    public static final String FUNC_SUBSTRING_BEFORE = "substring-before";
    public static final String FUNC_SUBSTRING_AFTER = "substring-after";
    public static final String FUNC_SUBSTRING = "substring";
    public static final String FUNC_STRING_LENGTH = "string-length";
    public static final String FUNC_NORMALIZE_SPACE = "normalize-space";
    public static final String FUNC_TRANSLATE = "translate";
    protected int type;

    public static XPathByteCodeElement createStringValueElement(String str, Document doc) {
        XPathByteCodeElement stringElement = XPathByteCodeElement.createValueElement("spush", doc);
        stringElement.setAttribute("_0", str);
        return stringElement;
    }

    public static XPathByteCodeElement createNumValueElement(int num, Document doc) {
        String str = "N" + String.valueOf(num);
        return XPathByteCodeElement.createValueElement(str, doc);
    }

    public static XPathByteCodeElement createBooleanValueElement(boolean bool, Document doc) {
        String str = String.valueOf(bool);
        return XPathByteCodeElement.createValueElement(str, doc);
    }

    public static XPathByteCodeElement createPredicateElement(Document doc) {
        String str = "clspush";
        return XPathByteCodeElement.createClosureElement(str, doc);
    }

    public static XPathByteCodeElement createAxisElement(String axis, Document doc) {
        if (!AXIS_MAP.contains(axis)) {
            throw new RuntimeException("Wrong axis name! :[" + axis + "]");
        }
        String str = "_" + axis;
        return XPathByteCodeElement.createValueElement(str, doc);
    }

    public static XPathByteCodeElement createStepElement(Document doc) {
        return XPathByteCodeElement.createExprElement("step", doc);
    }

    public static XPathByteCodeElement createContextLoadElement(Document doc) {
        return XPathByteCodeElement.createExprElement("ctxnload", doc);
    }

    public static XPathByteCodeElement createContextParamLoadElement(int index, Document doc) {
        if (index < 0 || index > 2) {
            throw new RuntimeException("Wrong index!. indexi is 0 or 1: [" + index + "]");
        }
        XPathByteCodeElement ctxpload = XPathByteCodeElement.createExprElement("ctxpload", doc);
        ctxpload.setAttribute("_0", String.valueOf(index));
        return ctxpload;
    }

    public static XPathByteCodeElement createFilterElement(Document doc) {
        return XPathByteCodeElement.createExprElement("filter", doc);
    }

    public static XPathByteCodeElement createNFilterElement(Document doc) {
        return XPathByteCodeElement.createExprElement("nfilter", doc);
    }

    public static XPathByteCodeElement createFcallElement(Document doc) {
        return XPathByteCodeElement.createExprElement("fcall", doc);
    }

    public static XPathByteCodeElement createUnionElement(Document doc) {
        return XPathByteCodeElement.createExprElement("union", doc);
    }

    public static XPathByteCodeElement createAndElement(Document doc) {
        return XPathByteCodeElement.createExprElement("and", doc);
    }

    public static XPathByteCodeElement createOrElement(Document doc) {
        return XPathByteCodeElement.createExprElement("or", doc);
    }

    public static XPathByteCodeElement createEqElement(Document doc) {
        return XPathByteCodeElement.createExprElement("eq", doc);
    }

    public static XPathByteCodeElement createNeElement(Document doc) {
        return XPathByteCodeElement.createExprElement("ne", doc);
    }

    public static XPathByteCodeElement createLtElement(Document doc) {
        return XPathByteCodeElement.createExprElement("lt", doc);
    }

    public static XPathByteCodeElement createLeElement(Document doc) {
        return XPathByteCodeElement.createExprElement("le", doc);
    }

    public static XPathByteCodeElement createGtElement(Document doc) {
        return XPathByteCodeElement.createExprElement("gt", doc);
    }

    public static XPathByteCodeElement createGeElement(Document doc) {
        return XPathByteCodeElement.createExprElement("ge", doc);
    }

    public static XPathByteCodeElement createAddElement(Document doc) {
        return XPathByteCodeElement.createExprElement("add", doc);
    }

    public static XPathByteCodeElement createSubElement(Document doc) {
        return XPathByteCodeElement.createExprElement("sub", doc);
    }

    public static XPathByteCodeElement createDivElement(Document doc) {
        return XPathByteCodeElement.createExprElement("div", doc);
    }

    public static XPathByteCodeElement createMultElement(Document doc) {
        return XPathByteCodeElement.createExprElement("mult", doc);
    }

    public static XPathByteCodeElement createModElement(Document doc) {
        return XPathByteCodeElement.createExprElement("mod", doc);
    }

    public static XPathByteCodeElement createNegElement(Document doc) {
        return XPathByteCodeElement.createExprElement("neg", doc);
    }

    private static XPathByteCodeElement createValueElement(String name, Document doc) {
        return new XPathByteCodeElement(doc.createElementNS("http://grain.jp/xpath/", "xpath:" + name), 0);
    }

    private static XPathByteCodeElement createExprElement(String name, Document doc) {
        return new XPathByteCodeElement(doc.createElementNS("http://grain.jp/xpath/", "xpath:" + name), 1);
    }

    private static XPathByteCodeElement createClosureElement(String name, Document doc) {
        return new XPathByteCodeElement(doc.createElementNS("http://grain.jp/xpath/", "xpath:" + name), 2);
    }

    private XPathByteCodeElement(Element e, int elementType) {
        super(e);
        this.type = elementType;
    }

    public int getByteCodeType() {
        return this.type;
    }

    static {
        AXIS_MAP.add(AXIS_ABSOLUTE);
        AXIS_MAP.add(AXIS_SELF);
        AXIS_MAP.add(AXIS_CHILD);
        AXIS_MAP.add(AXIS_PARENT);
        AXIS_MAP.add(AXIS_ANCESTOR);
        AXIS_MAP.add(AXIS_FOLLOWING);
        AXIS_MAP.add(AXIS_PRECEDING);
        AXIS_MAP.add(AXIS_ATTRIBUTE);
        AXIS_MAP.add(AXIS_NAMESPACE);
        AXIS_MAP.add(AXIS_DESCENDANT);
        AXIS_MAP.add(AXIS_ANCESTOR_OR_SELF);
        AXIS_MAP.add(AXIS_DESCENDANT_OR_SELF);
        AXIS_MAP.add(AXIS_FOLLOWING_SIBLING);
        AXIS_MAP.add(AXIS_PRECEDING_SIBLING);
    }
}

