/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.transformer.ElementHasLabelBaseTransformer;
import jp.haw.grain.transform.util.TargetNode;
import jp.haw.grain.transform.util.Util;
import jp.haw.grain.xpath.compiler.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XFormsElementTransformer
extends ElementHasLabelBaseTransformer {
    protected TargetNode targetNode;
    protected String gudElementName;
    protected boolean transformChildLabel;
    protected boolean isCopyAttrs;
    protected boolean havableChild;

    public XFormsElementTransformer(GudBuilder builder, TargetNode targetNode) {
        super(builder);
        this.targetNode = targetNode;
        this.transformChildLabel = false;
        this.isCopyAttrs = true;
        this.havableChild = true;
    }

    public XFormsElementTransformer(GudBuilder builder, TargetNode targetNode, String elementName) {
        this(builder, targetNode);
        this.gudElementName = elementName;
    }

    protected boolean isTarget(Node node) {
        return this.targetNode.equals(node);
    }

    public DocumentFragment transform() {
        Document dom = this.builder.getGudDoc();
        DocumentFragment df = dom.createDocumentFragment();
        Element gud = dom.createElementNS("http://grain.jp/gud/", this.gudElementName);
        Element xforms = (Element)this.node;
        if (this.isCopyAttrs) {
            Util.copyAttributes(xforms, gud);
            try {
                Util.compileNodeBinding(gud);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.transformChildLabel) {
            this.transformLabel(df, xforms);
        }
        df.appendChild(gud);
        this.current = gud;
        return df;
    }

    public Element getCurrentElement() {
        if (!this.havableChild) {
            return null;
        }
        return this.current;
    }

    public String getGudElementName() {
        return this.gudElementName;
    }

    public boolean isCopyAttrs() {
        return this.isCopyAttrs;
    }

    public boolean isTransformChildLabel() {
        return this.transformChildLabel;
    }

    public void setGudElementName(String string) {
        this.gudElementName = string;
    }

    public void setCopyAttrs(boolean b) {
        this.isCopyAttrs = b;
    }

    public void setTransformChildLabel(boolean b) {
        this.transformChildLabel = b;
    }

    public boolean isHavableChild() {
        return this.havableChild;
    }

    public void setHavableChild(boolean b) {
        this.havableChild = b;
    }
}

