package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.Util;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * @author nakajo
 */
public class Br2inline extends AbstractTransformer {

	public Br2inline(GudBuilder builder) {
		super(builder);
	}
	
	
	public Element getCurrentElement() {
		return null;
	}

	protected boolean isTarget(Node node) {
		if(node.getNodeType() != Node.ELEMENT_NODE) return false;
		
		Element e = (Element)node;
		if(e.getNamespaceURI() != GudBuilder.XHTML_NS) return false;
		
		return e.getLocalName().equals("br");
	}

	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#transform()
	 */
	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();
		
		DocumentFragment df = dom.createDocumentFragment();
		
		Element gud_inline = dom.createElementNS(GudBuilder.GUD_NS, "inline");
		gud_inline.setAttribute("break", "true");

		Util.copyAttributes((Element)node, gud_inline);
		df.appendChild(gud_inline);
		
		return df;
	}
	
}
