package jp.haw.grain.transform.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.xpath.XPathExprCompiler;
import jp.haw.grain.xpath.compiler.ParseException;

import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * ϊɕ֗Ȋ֐񋟂܂B
 * 
 * @author nakajo
 */
public class Util {

	/**
	 * Rs[vf̑SĂRs[vfɃRs[܂B
	 * 
	 * @param source
	 *            Rs[
	 * @param dest
	 *            Rs[
	 */
	public static void copyAttributes(Element source, Element dest) {

		NamedNodeMap attrs = source.getAttributes();
		for (int i = 0; i < attrs.getLength(); i++) {
			Node attr = attrs.item(i);
			if (attr.getNodeName().startsWith("xmlns")) {
				if (GudBuilder.XFORMS_NS.equals(attr.getNodeValue())) continue;
				if (GudBuilder.XHTML_NS.equals(attr.getNodeValue())) continue;
				if (attr.getNodeName().equals("xmlns")) {
					String uri = attr.getNodeValue();
					String prefix = uri.substring(uri.lastIndexOf("/") + 1);
					String separate = ":";
					if (uri == null || uri.equals("")) {
						prefix = "";
						separate = "";
					} else if (uri.endsWith("/")) {
						String[] prefixs = uri.split("/");
						prefix = prefixs[prefixs.length - 1];
					}

					dest.setAttribute("xmlns" + separate + prefix, uri);
					continue;
				}
			}

			if (attr.getNamespaceURI() != null) {
				dest.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
			} else {
				dest.setAttribute(attr.getNodeName(), attr.getNodeValue());
			}

			// Changed by David 2006.5.9
			changCSStoHTML(dest);

		}
	}

	/**
	 * ̑Ő󔒂ƑSẴ^uƉs폜Ԃ܂B
	 * 
	 * @param str
	 * @return
	 */
	public static String normalizedString(String str) {
		return str.replaceAll("\t", "").replaceAll("\r", "").replaceAll("\n", "").trim();
	}

	/**
	 * w肳ꂽm[h̐em[hTargetNodeł킳m[h݂邩ǂ Ă̐eɂĒׂĂ܂B
	 * 
	 * @param node
	 * @param target
	 * @return
	 */
	public static boolean parentNodeAs(Node node, TargetNode target) {
		Node parent = node.getParentNode();
		if (parent == null) return false;
		if (target.equals(parent)) return true;

		return parentNodeAs(parent, target);
	}

	public static void getTextContent(Element label, StringBuffer contentBuf) {
		if (!label.hasChildNodes()) return;

		NodeList list = label.getChildNodes();
		for (int i = 0; i < list.getLength(); i++) {
			Node node = list.item(i);
			if (node.getNodeType() == Node.TEXT_NODE) {
				contentBuf.append(node.getNodeValue());
			} else if (node.getNodeType() == Node.ELEMENT_NODE) {
				getTextContent((Element) node, contentBuf);
			}
		}

		return;
	}

	/**
	 * OvqvfׂĎ擾܂B
	 * 
	 * @param current
	 * @param name
	 * @return
	 */
	public static NodeList getNamedChildNode(Element current, String name) {
		return getNamedChildNode(current, null, name);
	}

	/**
	 * w肳ꂽOnamespaceURIvqvfׂĎ擾܂B
	 * namespaceURInull̂Ƃ͖OvqvfׂĎ擾܂B
	 * vqvf1Ȃꍇ͋NodeListԂ܂B
	 * 
	 * @param current
	 * @param namespaceUri
	 * @param name
	 * @return
	 */
	public static NodeList getNamedChildNode(Element current, String namespaceURI, String name) {
		DocumentFragment df = current.getOwnerDocument().createDocumentFragment();

		NodeList list = current.getChildNodes();
		for (int i = 0; i < list.getLength(); i++) {
			Node child = list.item(i);
			if (child != null && child.getLocalName() != null && child.getLocalName().equals(name)) {
				if (namespaceURI == null)
					df.appendChild(child);
				else if (namespaceURI.equals(child.getNamespaceURI())) df.appendChild(child);

				continue;
			}
		}

		return df.getChildNodes();
	}

	/**
	 * Element̑ɂstyle="background-color:#33ffcc" 
	 * background-color="#33ffcc"ɏ
	 * 
	 * @param sourceElement
	 * @return
	 */
	public static void changCSStoHTML(Element sourceElement) {

		NamedNodeMap attrs = sourceElement.getAttributes();
		for (int i = 0; i < attrs.getLength(); i++) {
			Node attr = attrs.item(i);

			if (attr.getNodeName().equals("style")) {
				String[] styleRoot = attr.getNodeValue().split(";");
				for (int j = 0; j < styleRoot.length; j++) {
					String[] styleChild = ((styleRoot[j]).trim()).split(":");
					sourceElement.removeAttribute("style");
					String name = styleChild[0].trim();
					String value = styleChild[1].trim();
					Pattern pattern = Pattern.compile("(\\d+)[^\\d]*");
					Matcher matcher = pattern.matcher(value);
					if (matcher.find()) {
						value = matcher.group(1);
					}
					sourceElement.setAttribute(name, value);
				}
			}

		}
	}

	/**
	 * vfm[hɎw肳ꂽXPathoCgR[hƂēWJ܂B
	 * 
	 * @param gudElement
	 */
	public static void compileNodeBinding(Element gudElement) throws ParseException {
		String[] targetAttrs = new String[] { "ref", "nodeset", "readonly", "required", "relevant", "calculate", "constraint" };

		NamedNodeMap attrs = gudElement.getAttributes();

		for (int i = 0; i < targetAttrs.length; i++) {
			Node binding = attrs.getNamedItem(targetAttrs[i]);
			if (binding == null) continue;

			String xpath = binding.getNodeValue();
			XPathExprCompiler compiler = new XPathExprCompiler();
			Node byteCodeNodeSet = compiler.compile(targetAttrs[i], xpath, gudElement.getOwnerDocument());
			gudElement.appendChild(byteCodeNodeSet);
			
			gudElement.removeAttribute(targetAttrs[i]); //RpC폜
		}
	}

}
