package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.TransformOperation;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author nakajo
 */
public class Br2inlineTest extends TestCase {

	/**
	 * br^OinlineɕϊVvȃeXg
	 *
	 */
	public void testSimpleTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "body", null);
		Element foo = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "foo");
		Element br = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "br");
		simpleDoc.getDocumentElement().appendChild(foo);
		simpleDoc.getDocumentElement().appendChild(br);
		
		Br2inline br2inline = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node inline = nodes.item(0);
				assertTrue("inline name check", inline.getNodeName().equals("inline"));
				NamedNodeMap attrs = inline.getAttributes();
				assertEquals("has break attribute check", attrs.getLength(), 1);
				Node aBreak = attrs.getNamedItem("break");
				assertTrue("break is true check", aBreak.getNodeValue().equals("true"));
				assertEquals("current is null check", t.getCurrentElement(), null);
			}
		};

		br2inline.apply(br, mockOperation);
	}

	/**
	 * namespaceXHTMLł͂Ȃ^O͕ϊȂ
	 *
	 */
	public void testNotXHTMLTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "body", null);
		Element foo = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "foo");
		Element br = simpleDoc.createElementNS("http://grain.jp/gud/", "br");
		simpleDoc.getDocumentElement().appendChild(foo);
		simpleDoc.getDocumentElement().appendChild(br);

		Br2inline br2inline = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		br2inline.apply(br, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	class MockTransformer extends Br2inline {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, boolean targetResult) {
			super(builder);
			this.targetResult = targetResult;
		}
		
		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}
}
