package jp.haw.grain.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.transformer.Bind2Bind;
import jp.haw.grain.transform.transformer.Body2View;
import jp.haw.grain.transform.transformer.BodyDescendants2Inline;
import jp.haw.grain.transform.transformer.Br2inline;
import jp.haw.grain.transform.transformer.DivAndGroup2Block;
import jp.haw.grain.transform.transformer.Html2Form;
import jp.haw.grain.transform.transformer.Item2Item;
import jp.haw.grain.transform.transformer.Label2Label;
import jp.haw.grain.transform.transformer.ModelChildCopy;
import jp.haw.grain.transform.transformer.P2InlineBlock;
import jp.haw.grain.transform.transformer.Secret2Textbox;
import jp.haw.grain.transform.transformer.Span2Inlinegroup;
import jp.haw.grain.transform.transformer.Submit2Button;
import jp.haw.grain.transform.transformer.Text2Inline;
import jp.haw.grain.transform.transformer.Textarea2Textbox;
import jp.haw.grain.transform.transformer.Transformer;
import jp.haw.grain.transform.transformer.TriggerAndSubmitChildCopy;
import jp.haw.grain.transform.transformer.XFormsElementTransformer;
import jp.haw.grain.transform.util.TargetNode;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author nakajo
 */
public class GudBuilder {

	//OԒ萔
	public static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
	public static final String XFORMS_NS = "http://www.w3.org/2002/xforms";
	public static final String EVENT_NS = "http://www.w3.org/2001/xml-events";
	public static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
	public static final String GUD_NS = "http://grain.jp/gud/";
	public static final String XPATH_NS = "http://grain.jp/xpath/";
	public static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
	public static final String XPATH_PREFIX = "xpath";
	
	//font-style萔
	public static final String STYLE_ITALIC = "italic";
	public static final String STYLE_BOLD = "bold";

	//font-size萔
	public static final String SIZE_LARGE = "large";
	public static final String SIZE_MEDIUM = "medium";
	public static final String SIZE_SMALL = "small";

	protected Document xhtmlDoc;
	protected Document gudDoc;
	protected Element currentGud;
	protected List skipNodeList;

	protected Transformer startTransformer;
	protected Map nsMap;

	protected int deep = 0;

	public GudBuilder(Document doc) {
		this.xhtmlDoc = doc;
		DOMImplementation domi = new DOMImplementationImpl();
		this.gudDoc = domi.createDocument(GudBuilder.GUD_NS, "form", null);
		this.currentGud = gudDoc.getDocumentElement();

		skipNodeList = new ArrayList();
		nsMap = new HashMap();
	}

	protected AbstractTransformer createTransformerChain() {
		AbstractTransformer html2form = new Html2Form(this);
		Bind2Bind bind2bind = new Bind2Bind(this);
		AbstractTransformer modelchildCopy = new ModelChildCopy(this);
		AbstractTransformer body2view = new Body2View(this);

		XFormsElementTransformer input2textbox = new XFormsElementTransformer(this, new TargetNode(GudBuilder.XFORMS_NS, "input", Node.ELEMENT_NODE), "textbox");
		
		AbstractTransformer secret2Textbox = new Secret2Textbox(this);
		AbstractTransformer textarea2Textbox = new Textarea2Textbox(this);

		XFormsElementTransformer output2inline = new XFormsElementTransformer(this, new TargetNode(GudBuilder.XFORMS_NS, "output", Node.ELEMENT_NODE), "inline");
		output2inline.setTransformChildLabel(true);
		
		XFormsElementTransformer trigger2button = new XFormsElementTransformer(this, new TargetNode(GudBuilder.XFORMS_NS, "trigger", Node.ELEMENT_NODE), "button");

		AbstractTransformer triggerChildCopy = new TriggerAndSubmitChildCopy(this);
		AbstractTransformer submit2Button = new Submit2Button(this);

		XFormsElementTransformer select2Select = new XFormsElementTransformer(this, new TargetNode(GudBuilder.XFORMS_NS, "select", Node.ELEMENT_NODE), "select");
		
		XFormsElementTransformer select12Choice = new XFormsElementTransformer(this, new TargetNode(GudBuilder.XFORMS_NS, "select1", Node.ELEMENT_NODE), "choice");
		
		AbstractTransformer item2Item = new Item2Item(this);
		
		XFormsElementTransformer switch2TabBlock = new XFormsElementTransformer(this, new TargetNode(GudBuilder.XFORMS_NS, "switch", Node.ELEMENT_NODE), "tab-block");

		XFormsElementTransformer choices2Choices = new XFormsElementTransformer(this, new TargetNode(GudBuilder.XFORMS_NS, "choices", Node.ELEMENT_NODE), "choices");
		
		XFormsElementTransformer case2Inlinblock = new XFormsElementTransformer(this, new TargetNode(GudBuilder.XFORMS_NS, "case", Node.ELEMENT_NODE), "block");

		Label2Label label2Label = new Label2Label(this);
		XFormsElementTransformer toggle2Toggle = new XFormsElementTransformer(this, new TargetNode(GudBuilder.XFORMS_NS, "toggle", Node.ELEMENT_NODE), "toggle");
		XFormsElementTransformer upload2upload = new XFormsElementTransformer(this, new TargetNode(GudBuilder.XFORMS_NS, "upload", Node.ELEMENT_NODE), "upload");
		
		XFormsElementTransformer mediatype2mediatype = new XFormsElementTransformer(this, new TargetNode(GudBuilder.XFORMS_NS, "mediatype", Node.ELEMENT_NODE), "mediatype");
		XFormsElementTransformer filename2Filename = new XFormsElementTransformer(this, new TargetNode(GudBuilder.XFORMS_NS, "filename", Node.ELEMENT_NODE), "filename");
		XFormsElementTransformer img2image = new XFormsElementTransformer(this, new TargetNode(GudBuilder.XHTML_NS, "img", Node.ELEMENT_NODE), "image");

		AbstractTransformer divAndGroup2Block = new DivAndGroup2Block(this);
		AbstractTransformer p2inlineblock = new P2InlineBlock(this);
		AbstractTransformer span2inlinegroup = new Span2Inlinegroup(this);
		AbstractTransformer br2inline = new Br2inline(this);

		//bodyȉinlineɕϊvf̐ݒ
		//cite,dfn,em,i,var
		BodyDescendants2Inline toItalicInline = new BodyDescendants2Inline(this);
		toItalicInline.setTargetLocalNames(new String[] { "cite", "dfn", "em", "i", "var" });
		toItalicInline.setStyle(GudBuilder.STYLE_ITALIC);

		//b, strong
		BodyDescendants2Inline toBoldInline = new BodyDescendants2Inline(this);
		toBoldInline.setTargetLocalNames(new String[] { "b", "strong" });
		toBoldInline.setStyle(GudBuilder.STYLE_BOLD);

		//hxn h1,h2ƂBBB
		BodyDescendants2Inline hxToInline = new BodyDescendants2Inline(this);
		hxToInline.setTargetLocalNames(new String[] { "h1", "h2", "h3", "h4", "h5", "h6" });
		hxToInline.setStyle(GudBuilder.STYLE_BOLD);
		hxToInline.setSize(GudBuilder.SIZE_LARGE);

		//big
		BodyDescendants2Inline bigToInline = new BodyDescendants2Inline(this);
		bigToInline.setTargetLocalNames(new String[] { "big" });
		bigToInline.setSize(GudBuilder.SIZE_LARGE);

		//small
		BodyDescendants2Inline smallToInline = new BodyDescendants2Inline(this);
		smallToInline.setTargetLocalNames(new String[] { "small" });
		smallToInline.setSize(GudBuilder.SIZE_SMALL);

		AbstractTransformer text2inline = new Text2Inline(this);

		//chain̍\z

		html2form.setNext(bind2bind);
		bind2bind.setNext(modelchildCopy);
		modelchildCopy.setNext(body2view);
		body2view.setNext(output2inline);
		output2inline.setNext(input2textbox);
		input2textbox.setNext(secret2Textbox);
		secret2Textbox.setNext(textarea2Textbox);
		textarea2Textbox.setNext(trigger2button);

		trigger2button.setNext(submit2Button);
		submit2Button.setNext(triggerChildCopy);
		triggerChildCopy.setNext(upload2upload);
		upload2upload.setNext(mediatype2mediatype);
		mediatype2mediatype.setNext(filename2Filename);
		filename2Filename.setNext(img2image);
		img2image.setNext(select2Select);
		
		select2Select.setNext(select12Choice);
		select12Choice.setNext(choices2Choices);
		choices2Choices.setNext(item2Item);
		item2Item.setNext(switch2TabBlock);
		switch2TabBlock.setNext(case2Inlinblock);
		case2Inlinblock.setNext(label2Label);
		label2Label.setNext(toggle2Toggle);
		toggle2Toggle.setNext(divAndGroup2Block);
		
		divAndGroup2Block.setNext(p2inlineblock);
		p2inlineblock.setNext(span2inlinegroup);
		span2inlinegroup.setNext(toItalicInline);

		toItalicInline.setNext(toBoldInline);
		toBoldInline.setNext(hxToInline);
		hxToInline.setNext(bigToInline);
		bigToInline.setNext(smallToInline);
		smallToInline.setNext(br2inline);

		br2inline.setNext(text2inline);

		return html2form;
	}

	/**
	 * OԂǉ܂B
	 * @param prefix
	 * @param namespaceURI
	 */
	public void addNamespace(String prefix, String namespaceURI) {
		this.nsMap.put(prefix, namespaceURI);
	}

	protected void transformNode(Node node, TransformOperation operation) throws GudTransformException {
		try {
			if (!isSkipNode(node)) { //XLbvΏۂȂϊȂB
				createTransformerChain().apply(node, operation);
			}
		} catch (Exception e) {
			throw new GudTransformException("deep=" + deep + " node="+node.getClass().getName()+"[" + node.getNodeName()+": "+node.getNamespaceURI()+": "+node.getNodeValue(), e);
		}

		//qĂȂΏI
		if (!node.hasChildNodes())
			return;

		deep++;
		//qvfĂȂqvfϊ
		NodeList children = node.getChildNodes();

		for (int i = 0; i < children.getLength(); i++) {
			//qvfǉ邽߂̃Iy[V擾
			TransformOperation childOperation = operation.createChildNodeOperation();
			transformNode(children.item(i), childOperation);
		}
		deep--;
	}

	/**
	 * w肳ꂽm[hXLbvΏۂǂԂ܂B
	 * @param node
	 * @return
	 */
	protected boolean isSkipNode(Node node) {
		for (int i = 0; i < this.skipNodeList.size(); i++) {
			if (this.skipNodeList.get(i).equals(node)) {
				//XLbvΏ
				//XLbvXg폜B
				this.skipNodeList.remove(node);
				return true;
			}
		}

		return false;
	}

	/**
	 * gud\z܂B
	 * @return
	 */
	public Document build() throws GudTransformException {
		Element xhtmlRoot = this.xhtmlDoc.getDocumentElement();
		TransformOperation operation = new TransformOperation(this.currentGud);
		transformNode(xhtmlRoot, operation);

		Element form = this.gudDoc.getDocumentElement();
		//formnamespace錾ǉ
		form.setAttribute("xmlns", GudBuilder.GUD_NS); //default
		form.setAttribute("xmlns:"+GudBuilder.XPATH_PREFIX, GudBuilder.XPATH_NS); //XPathoCgޗp
		//form.setAttribute("xmlns:ev", GudBuilder.EVENT_NS); // ev:

		//ȊOƂ낭
		Iterator keys = nsMap.keySet().iterator();
		while (keys.hasNext()) {
			String prefix = keys.next().toString();
			String ns = nsMap.get(prefix).toString();

			//mnamespace͖
			if (GudBuilder.XFORMS_NS.equals(ns))
				continue;
			if (GudBuilder.XHTML_NS.equals(ns))
				continue;
			if (GudBuilder.XMLNS_NS.equals(ns))
				continue;
			form.setAttribute("xmlns:" + prefix, ns);
		}

		return this.gudDoc;
	}

	public Document getGudDoc() {
		return this.gudDoc;
	}

	public void addSkipNode(Node node) {
		if (node == null)
			return;
		this.skipNodeList.add(node);
	}

}
