package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.TransformOperation;
import jp.haw.grain.transform.util.TargetNode;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author nakajo
 */
public class XFormsElementTransformerTest extends TestCase {

	/**
	 * XForms̗vfgudvfɕϊB
	 *
	 */
	public void testSimpleTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "switch", null);
		Element Eswitch = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		label.setTextContent("I");
		Element Ecase = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase.setAttribute("id", "hello");
		Element font = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "font");
		font.setAttribute("size", "2");
		font.setTextContent("ɂ");

		Element Ecase2 = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase2.setAttribute("id", "bye");
		Element font2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		font2.setTextContent("悤Ȃ");
		
		Eswitch.appendChild(label);
		Eswitch.appendChild(Ecase);
		Ecase.appendChild(font);
		Eswitch.appendChild(Ecase2);
		Ecase2.appendChild(font2);

		TargetNode targetNode = new TargetNode(GudBuilder.XFORMS_NS, "switch", Node.ELEMENT_NODE);
		XFormsElementTransformer trans = new MockTransformer(new GudBuilder(simpleDoc), targetNode, true);
		trans.setGudElementName("tab-block");
		
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);
				Node tabblock = nodes.item(0);
				assertEquals("name check", tabblock.getLocalName(), "tab-block");
				assertEquals("NS check", tabblock.getNamespaceURI(), GudBuilder.GUD_NS);
				
				assertTrue("current is not null check", t.getCurrentElement() != null);
			}
		};

		trans.apply(Eswitch, mockOperation);
	}

	/**
	 * XForms̗vfgudvfɕϊB
	 * ̃Rs[`FbN
	 *
	 */
	public void testAttrsCopy() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "switch", null);
		Element Eswitch = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		label.setTextContent("I");
		Element Ecase = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase.setAttribute("id", "hello");
		Element font = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "font");
		font.setAttribute("size", "2");
		font.setTextContent("ɂ");

		Element Ecase2 = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase2.setAttribute("id", "bye");
		Element font2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		font2.setTextContent("悤Ȃ");
		
		Eswitch.appendChild(label);
		Eswitch.appendChild(Ecase);
		Ecase.appendChild(font);
		Eswitch.appendChild(Ecase2);
		Ecase2.appendChild(font2);

		TargetNode targetNode = new TargetNode(GudBuilder.XFORMS_NS, "case", Node.ELEMENT_NODE);
		XFormsElementTransformer trans = new MockTransformer(new GudBuilder(simpleDoc), targetNode, true);
		trans.setGudElementName("case");
		
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);
				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "case");
				assertEquals("NS check", node.getNamespaceURI(), GudBuilder.GUD_NS);

				NamedNodeMap attrs = node.getAttributes();
				assertEquals("attrs length check", attrs.getLength(), 1);
				Node id = attrs.item(0);
				assertEquals("attr name check", id.getNodeName(), "id");
				assertEquals("attr has same value", id.getNodeValue(), "hello");
				
				assertTrue("current is not null check", t.getCurrentElement() != null);
			}
		};

		trans.apply(Ecase, mockOperation);
	}

	/**
	 * XForms̗vfgudvfɕϊB
	 * currentvffalseUݒ
	 *
	 */
	public void testNoCurrent() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "switch", null);
		Element Eswitch = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		label.setTextContent("I");
		Element Ecase = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase.setAttribute("id", "hello");
		Element font = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "font");
		font.setAttribute("size", "2");
		font.setTextContent("ɂ");

		Element Ecase2 = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase2.setAttribute("id", "bye");
		Element font2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		font2.setTextContent("悤Ȃ");
		
		Eswitch.appendChild(label);
		Eswitch.appendChild(Ecase);
		Ecase.appendChild(font);
		Eswitch.appendChild(Ecase2);
		Ecase2.appendChild(font2);

		TargetNode targetNode = new TargetNode(GudBuilder.XFORMS_NS, "case", Node.ELEMENT_NODE);
		XFormsElementTransformer trans = new MockTransformer(new GudBuilder(simpleDoc), targetNode, true);
		trans.setGudElementName("case");
		trans.setHavableChild(false);
		
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);
				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "case");
				assertEquals("NS check", node.getNamespaceURI(), GudBuilder.GUD_NS);

				NamedNodeMap attrs = node.getAttributes();
				assertEquals("attrs length check", attrs.getLength(), 1);
				Node id = attrs.item(0);
				assertEquals("attr name check", id.getNodeName(), "id");
				assertEquals("attr has same value", id.getNodeValue(), "hello");
				
				assertTrue("current is not null check", t.getCurrentElement() == null);
			}
		};

		trans.apply(Ecase, mockOperation);
	}

	/**
	 * XForms̗vfgudvfɕϊB
	 * ̃Rs[falseɐݒ
	 *
	 */
	public void testNotCopyAttrs() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "switch", null);
		Element Eswitch = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		label.setTextContent("I");
		Element Ecase = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase.setAttribute("id", "hello");
		Element font = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "font");
		font.setAttribute("size", "2");
		font.setTextContent("ɂ");

		Element Ecase2 = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase2.setAttribute("id", "bye");
		Element font2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		font2.setTextContent("悤Ȃ");
		
		Eswitch.appendChild(label);
		Eswitch.appendChild(Ecase);
		Ecase.appendChild(font);
		Eswitch.appendChild(Ecase2);
		Ecase2.appendChild(font2);

		TargetNode targetNode = new TargetNode(GudBuilder.XFORMS_NS, "case", Node.ELEMENT_NODE);
		XFormsElementTransformer trans = new MockTransformer(new GudBuilder(simpleDoc), targetNode, true);
		trans.setGudElementName("case");
		trans.setHavableChild(false);
		trans.setCopyAttrs(false);
		
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);
				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "case");
				assertEquals("NS check", node.getNamespaceURI(), GudBuilder.GUD_NS);

				NamedNodeMap attrs = node.getAttributes();
				assertEquals("attrs length check", attrs.getLength(), 0);
				
				assertTrue("current is not null check", t.getCurrentElement() == null);
			}
		};

		trans.apply(Ecase, mockOperation);
	}

	/**
	 * label̓WJfalseɐݒ
	 *
	 */
	public void testNotTransformLabel() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "switch", null);
		Element Eswitch = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		label.setTextContent("I");
		Element Ecase = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase.setAttribute("id", "hello");
		Element font = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "font");
		font.setAttribute("size", "2");
		font.setTextContent("ɂ");

		Element Ecase2 = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase2.setAttribute("id", "bye");
		Element font2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		font2.setTextContent("悤Ȃ");
		
		Eswitch.appendChild(label);
		Eswitch.appendChild(Ecase);
		Ecase.appendChild(font);
		Eswitch.appendChild(Ecase2);
		Ecase2.appendChild(font2);

		TargetNode targetNode = new TargetNode(GudBuilder.XFORMS_NS, "switch", Node.ELEMENT_NODE);
		XFormsElementTransformer trans = new MockTransformer(new GudBuilder(simpleDoc), targetNode, true);
		trans.setGudElementName("tab-block");
		trans.setHavableChild(false);
		trans.setCopyAttrs(false);
		trans.setTransformChildLabel(false);
		
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);
				Node tabblock = nodes.item(0);
				
				assertEquals("name check", tabblock.getLocalName(), "tab-block");
				assertEquals("NS check", tabblock.getNamespaceURI(), GudBuilder.GUD_NS);
				
				assertTrue("current is not null check", t.getCurrentElement() == null);
			}
		};

		trans.apply(Eswitch, mockOperation);
	}

	/**
	 * ϊΏۃ^O̕sv
	 *
	 */
	public void testWrongTarget() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "switch", null);
		Element Eswitch = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		label.setTextContent("I");
		Element Ecase = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase.setAttribute("id", "hello");
		Element font = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "font");
		font.setAttribute("size", "2");
		font.setTextContent("ɂ");

		Element Ecase2 = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase2.setAttribute("id", "bye");
		Element font2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		font2.setTextContent("悤Ȃ");
		
		Eswitch.appendChild(label);
		Eswitch.appendChild(Ecase);
		Ecase.appendChild(font);
		Eswitch.appendChild(Ecase2);
		Ecase2.appendChild(font2);

		TargetNode targetNode = new TargetNode(GudBuilder.XFORMS_NS, "switch", Node.ELEMENT_NODE);
		XFormsElementTransformer trans = new MockTransformer(new GudBuilder(simpleDoc), targetNode, false);
		trans.setGudElementName("tab-block");
		trans.setHavableChild(false);
		trans.setCopyAttrs(false);
		trans.setTransformChildLabel(false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		trans.apply(Ecase, mockOperation);
		mockOperation.createChildNodeOperation();
		trans.apply(font, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	/**
	 * ϊΏۃ^O̕sv, NS̕sv
	 *
	 */
	public void testWrongTargetNS() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "switch", null);
		Element Eswitch = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		label.setTextContent("I");
		Element Ecase = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase.setAttribute("id", "hello");
		Element font = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "font");
		font.setAttribute("size", "2");
		font.setTextContent("ɂ");

		Element Ecase2 = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "case");
		Ecase2.setAttribute("id", "bye");
		Element font2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		font2.setTextContent("悤Ȃ");
		
		Eswitch.appendChild(label);
		Eswitch.appendChild(Ecase);
		Ecase.appendChild(font);
		Eswitch.appendChild(Ecase2);
		Ecase2.appendChild(font2);

		TargetNode targetNode = new TargetNode(GudBuilder.XHTML_NS, "switch", Node.ELEMENT_NODE);
		XFormsElementTransformer trans = new MockTransformer(new GudBuilder(simpleDoc), targetNode, false);
		trans.setGudElementName("tab-block");
		trans.setHavableChild(false);
		trans.setCopyAttrs(false);
		trans.setTransformChildLabel(false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		trans.apply(Ecase, mockOperation);
		mockOperation.createChildNodeOperation();
		trans.apply(Eswitch, mockOperation);
		mockOperation.createChildNodeOperation();
		trans.apply(font, mockOperation);
		mockOperation.createChildNodeOperation();
	}
	
	class MockTransformer extends XFormsElementTransformer {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, TargetNode targetNode, boolean targetResult) {
			super(builder, targetNode);
			this.targetResult = targetResult;
		}

		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}

}
