package jp.haw.grain.transform.transformer;

import java.io.IOException;
import java.io.StringWriter;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.TransformOperation;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Bind2BindTest extends TestCase {

	/**
	 * bindvftype̒lxsd:integer̂ƂnumberɕύXeXg
	 *
	 */
	public void testNumberType() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "bind", null);
		Element bind = simpleDoc.getDocumentElement();
		bind.setAttribute("type", "xsd:integer");
		
		Bind2Bind bind2bind = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node bind = nodes.item(0);
				assertEquals("transformed element check", bind.getNodeName(), "bind");
				NamedNodeMap attrs = bind.getAttributes();
				Node type = attrs.getNamedItem("type");
				assertTrue("type check", type.getNodeValue().equals("number"));
			}
		};

		bind2bind.apply(simpleDoc.getDocumentElement(), mockOperation);
	}

	/**
	 * bindvftype̒lxsd:boolean̂ƂboolɕύXeXg
	 *
	 */
	public void testBooleanType() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "bind", null);
		Element bind = simpleDoc.getDocumentElement();
		bind.setAttribute("type", "xsd:boolean");
		
		Bind2Bind bind2bind = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node bind = nodes.item(0);
				assertEquals("transformed element check", bind.getNodeName(), "bind");
				NamedNodeMap attrs = bind.getAttributes();
				Node type = attrs.getNamedItem("type");
				assertTrue("type check", type.getNodeValue().equals("bool"));
			}
		};

		bind2bind.apply(simpleDoc.getDocumentElement(), mockOperation);
	}

	/**
	 * bindvftype̒lLQȊÔƂstringɕύXeXg
	 *
	 */
	public void testStringType() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "bind", null);
		Element bind = simpleDoc.getDocumentElement();
		bind.setAttribute("type", "xsd:float");
		
		Bind2Bind bind2bind = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node bind = nodes.item(0);
				assertEquals("transformed element check", bind.getNodeName(), "bind");
				NamedNodeMap attrs = bind.getAttributes();
				Node type = attrs.getNamedItem("type");
				assertTrue("type check", type.getNodeValue().equals("string"));
			}
		};

		//xsd:float
		bind2bind.apply(bind, mockOperation);
		
		//gYearMonth
		bind.setAttribute("type", "xsd:gYearMonth");
		bind2bind.apply(bind, mockOperation);

		//my:cc
		bind.setAttribute("type", "my:cc");
		bind2bind.apply(bind, mockOperation);

		//xsd:string
		bind.setAttribute("type", "xsd:string");
		bind2bind.apply(bind, mockOperation);
	}

	/**
	 * bindvftypeȂƂ̃eXg
	 *
	 */
	public void testNonType() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "bind", null);
		Element bind = simpleDoc.getDocumentElement();
		
		Bind2Bind bind2bind = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node bind = nodes.item(0);
				assertEquals("transformed element check", bind.getNodeName(), "bind");
				NamedNodeMap attrs = bind.getAttributes();
				Node type = attrs.getNamedItem("type");
				assertNull("type check", type);
			}
		};

		bind2bind.apply(bind, mockOperation);
	}

	/**
	 * bindvfredonly̓RpCăoCgR[hɕϊeXg
	 *
	 */
	public void testReadonly() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "bind", null);
		Element bind = simpleDoc.getDocumentElement();
		bind.setAttribute("readonly", "payment='cc'");
		
		final String compileExpr = 
			"<xpath:expr name=\"readonly\">" +
				"<xpath:_child/>" +
				"<xpath:ctxnload/>" +
				"<xpath:step _0=\"payment\" _1=\"\"/>" +
				"<xpath:spush _0=\"cc\"/>" +
				"<xpath:eq/>" +
			"</xpath:expr>";

		Bind2Bind bind2bind = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node bind = nodes.item(0);
				assertEquals("transformed element check", bind.getNodeName(), "bind");
				NamedNodeMap attrs = bind.getAttributes();
				Node readonly = attrs.getNamedItem("readonly");
				assertNull("type check", readonly);
				
				//bind̓RpCς݂̃oCgR[hqvfɂĂ
				Node expr = bind.getChildNodes().item(0);
				assertNotNull("expr check", expr);
				try {
				assertEquals("expr string check", compileExpr, element2String((Element)expr));
				} catch(Exception e) {
					fail(e.toString());
				}
				
			}
		};

		bind2bind.apply(bind, mockOperation);
	}

	/**
	 * bindvfrequired̓RpCăoCgR[hɕϊeXg
	 *
	 */
	public void testRequired() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "bind", null);
		Element bind = simpleDoc.getDocumentElement();
		bind.setAttribute("required", "payment='cc'");
		
		final String compileExpr = 
			"<xpath:expr name=\"required\">" +
				"<xpath:_child/>" +
				"<xpath:ctxnload/>" +
				"<xpath:step _0=\"payment\" _1=\"\"/>" +
				"<xpath:spush _0=\"cc\"/>" +
				"<xpath:eq/>" +
			"</xpath:expr>";

		Bind2Bind bind2bind = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node bind = nodes.item(0);
				assertEquals("transformed element check", bind.getNodeName(), "bind");
				NamedNodeMap attrs = bind.getAttributes();
				Node readonly = attrs.getNamedItem("required");
				assertNull("type check", readonly);
				
				//bind̓RpCς݂̃oCgR[hqvfɂĂ
				Node expr = bind.getChildNodes().item(0);
				assertNotNull("expr check", expr);
				try {
				assertEquals("expr string check", compileExpr, element2String((Element)expr));
				} catch(Exception e) {
					fail(e.toString());
				}
				
			}
		};

		bind2bind.apply(bind, mockOperation);
	}

	/**
	 * bindvfrelevant̓RpCăoCgR[hɕϊeXg
	 *
	 */
	public void testRelevant() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "bind", null);
		Element bind = simpleDoc.getDocumentElement();
		bind.setAttribute("relevant", "payment='cc'");
		
		final String compileExpr = 
			"<xpath:expr name=\"relevant\">" +
				"<xpath:_child/>" +
				"<xpath:ctxnload/>" +
				"<xpath:step _0=\"payment\" _1=\"\"/>" +
				"<xpath:spush _0=\"cc\"/>" +
				"<xpath:eq/>" +
			"</xpath:expr>";

		Bind2Bind bind2bind = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node bind = nodes.item(0);
				assertEquals("transformed element check", bind.getNodeName(), "bind");
				NamedNodeMap attrs = bind.getAttributes();
				Node readonly = attrs.getNamedItem("relevant");
				assertNull("type check", readonly);
				
				//bind̓RpCς݂̃oCgR[hqvfɂĂ
				Node expr = bind.getChildNodes().item(0);
				assertNotNull("expr check", expr);
				try {
				assertEquals("expr string check", compileExpr, element2String((Element)expr));
				} catch(Exception e) {
					fail(e.toString());
				}
				
			}
		};

		bind2bind.apply(bind, mockOperation);
	}

	/**
	 * bindvfconstraint̓RpCăoCgR[hɕϊeXg
	 *
	 */
	public void testConstraint() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "bind", null);
		Element bind = simpleDoc.getDocumentElement();
		bind.setAttribute("constraint", "payment='cc'");
		
		final String compileExpr = 
			"<xpath:expr name=\"constraint\">" +
				"<xpath:_child/>" +
				"<xpath:ctxnload/>" +
				"<xpath:step _0=\"payment\" _1=\"\"/>" +
				"<xpath:spush _0=\"cc\"/>" +
				"<xpath:eq/>" +
			"</xpath:expr>";

		Bind2Bind bind2bind = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node bind = nodes.item(0);
				assertEquals("transformed element check", bind.getNodeName(), "bind");
				NamedNodeMap attrs = bind.getAttributes();
				Node readonly = attrs.getNamedItem("constraint");
				assertNull("type check", readonly);
				
				//bind̓RpCς݂̃oCgR[hqvfɂĂ
				Node expr = bind.getChildNodes().item(0);
				assertNotNull("expr check", expr);
				try {
				assertEquals("expr string check", compileExpr, element2String((Element)expr));
				} catch(Exception e) {
					fail(e.toString());
				}
				
			}
		};

		bind2bind.apply(bind, mockOperation);
	}

	/**
	 * bindvfcalculate̓RpCăoCgR[hɕϊeXg
	 *
	 */
	public void testcalculate() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "bind", null);
		Element bind = simpleDoc.getDocumentElement();
		bind.setAttribute("calculate", "payment='cc'");
		
		final String compileExpr = 
			"<xpath:expr name=\"calculate\">" +
				"<xpath:_child/>" +
				"<xpath:ctxnload/>" +
				"<xpath:step _0=\"payment\" _1=\"\"/>" +
				"<xpath:spush _0=\"cc\"/>" +
				"<xpath:eq/>" +
			"</xpath:expr>";

		Bind2Bind bind2bind = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node bind = nodes.item(0);
				assertEquals("transformed element check", bind.getNodeName(), "bind");
				NamedNodeMap attrs = bind.getAttributes();
				Node readonly = attrs.getNamedItem("calculate");
				assertNull("type check", readonly);
				
				//bind̓RpCς݂̃oCgR[hqvfɂĂ
				Node expr = bind.getChildNodes().item(0);
				assertNotNull("expr check", expr);
				try {
				assertEquals("expr string check", compileExpr, element2String((Element)expr));
				} catch(Exception e) {
					fail(e.toString());
				}
				
			}
		};

		bind2bind.apply(bind, mockOperation);
	}


	private String element2String(Element element) throws IOException {
		StringWriter out = new StringWriter();
		
		//o̓tH[}bg̎w
		OutputFormat formatter = new OutputFormat();
		//󔒕̕ۑ
		formatter.setPreserveSpace(true);
		formatter.setIndenting(false);
		formatter.setOmitXMLDeclaration(true);
		formatter.setEncoding("Shift_JIS");
		//XMLSerializer ̍쐬
		XMLSerializer serializer = new XMLSerializer(out, formatter);

		serializer.serialize(element);
		return out.toString();
	}

	class MockTransformer extends Bind2Bind {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, boolean targetResult) {
			super(builder);
			this.targetResult = targetResult;
		}
		
		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}
}
