/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.framework.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;

public class Util {
    public static String encodeBase64(byte[] data) throws IOException, UnsupportedEncodingException, MessagingException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        OutputStream out = MimeUtility.encode((OutputStream)bao, (String)"base64");
        out.write(data);
        out.close();
        return bao.toString("ISO-8859-1");
    }

    public static byte[] decodeBase64(String str) throws IOException, UnsupportedEncodingException, MessagingException {
        int len;
        InputStream in = MimeUtility.decode((InputStream)new ByteArrayInputStream(str.getBytes("ISO-8859-1")), (String)"base64");
        byte[] buf = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        return out.toByteArray();
    }

    public static void dumpBytes(byte[] b) {
        int len = 16;
        int max = b.length + len;
        int i = 0;
        for (int of = 0; of < max; of += len) {
            System.out.println("*** dump[" + i + "] : " + Util.toHex(b, of, len) + "---" + Util.toAscii(b, of, len));
        }
    }

    public static String toAscii(byte[] data, int offset, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = offset; i < offset + len; ++i) {
            if (i >= data.length) {
                buf.append("   ");
                continue;
            }
            int c = 0xFF & data[i];
            if (c < 32 || 128 < c) {
                buf.append("\\").append(Util.toHex(data[i]));
                continue;
            }
            buf.append("  ").append((char)c);
        }
        return buf.toString();
    }

    public static String toHex(byte[] data, int offset, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = offset; i < offset + len; ++i) {
            if (i % 4 == 0) {
                buf.append(" ");
            }
            if (i >= data.length) {
                buf.append("  ");
                continue;
            }
            buf.append(Util.toHex(data[i]));
        }
        return buf.toString();
    }

    public static String toHex(byte data) {
        char[] hex = new char[]{Util.getHexChar((data & 0xF0) >>> 4), Util.getHexChar(data & 0xF)};
        return String.valueOf(hex);
    }

    public static char getHexChar(int val) {
        if (val < 10) {
            return (char)(48 + val);
        }
        return (char)(97 + (val - 10));
    }
}

