/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.haw.grain.transform.util.TargetNode;
import jp.haw.grain.transform.xpath.XPathExprCompiler;
import jp.haw.grain.xpath.compiler.ParseException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Util {
    public static void copyAttributes(Element source, Element dest) {
        NamedNodeMap attrs = source.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            if (attr.getNodeName().startsWith("xmlns")) {
                if ("http://www.w3.org/2002/xforms".equals(attr.getNodeValue()) || "http://www.w3.org/1999/xhtml".equals(attr.getNodeValue())) continue;
                if (attr.getNodeName().equals("xmlns")) {
                    String uri = attr.getNodeValue();
                    String prefix = uri.substring(uri.lastIndexOf("/") + 1);
                    String separate = ":";
                    if (uri == null || uri.equals("")) {
                        prefix = "";
                        separate = "";
                    } else if (uri.endsWith("/")) {
                        String[] prefixs = uri.split("/");
                        prefix = prefixs[prefixs.length - 1];
                    }
                    dest.setAttribute("xmlns" + separate + prefix, uri);
                    continue;
                }
            }
            if (attr.getNamespaceURI() != null) {
                dest.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
            } else {
                dest.setAttribute(attr.getNodeName(), attr.getNodeValue());
            }
            Util.changCSStoHTML(dest);
        }
    }

    public static String normalizedString(String str) {
        return str.replaceAll("\t", "").replaceAll("\r", "").replaceAll("\n", "").trim();
    }

    public static boolean parentNodeAs(Node node, TargetNode target) {
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        if (target.equals(parent)) {
            return true;
        }
        return Util.parentNodeAs(parent, target);
    }

    public static void getTextContent(Element label, StringBuffer contentBuf) {
        if (!label.hasChildNodes()) {
            return;
        }
        NodeList list = label.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() == 3) {
                contentBuf.append(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            Util.getTextContent((Element)node, contentBuf);
        }
    }

    public static NodeList getNamedChildNode(Element current, String name) {
        return Util.getNamedChildNode(current, null, name);
    }

    public static NodeList getNamedChildNode(Element current, String namespaceURI, String name) {
        DocumentFragment df = current.getOwnerDocument().createDocumentFragment();
        NodeList list = current.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child == null || child.getLocalName() == null || !child.getLocalName().equals(name)) continue;
            if (namespaceURI == null) {
                df.appendChild(child);
                continue;
            }
            if (!namespaceURI.equals(child.getNamespaceURI())) continue;
            df.appendChild(child);
        }
        return df.getChildNodes();
    }

    public static void changCSStoHTML(Element sourceElement) {
        NamedNodeMap attrs = sourceElement.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            if (!attr.getNodeName().equals("style")) continue;
            String[] styleRoot = attr.getNodeValue().split(";");
            for (int j = 0; j < styleRoot.length; ++j) {
                String[] styleChild = styleRoot[j].trim().split(":");
                sourceElement.removeAttribute("style");
                String name = styleChild[0].trim();
                String value = styleChild[1].trim();
                Pattern pattern = Pattern.compile("(\\d+)[^\\d]*");
                Matcher matcher = pattern.matcher(value);
                if (matcher.find()) {
                    value = matcher.group(1);
                }
                sourceElement.setAttribute(name, value);
            }
        }
    }

    public static void compileNodeBinding(Element gudElement, String[] targetAttrs) throws ParseException {
        NamedNodeMap attrs = gudElement.getAttributes();
        for (int i = 0; i < targetAttrs.length; ++i) {
            Node binding = attrs.getNamedItem(targetAttrs[i]);
            if (binding == null) continue;
            String xpath = binding.getNodeValue();
            XPathExprCompiler compiler = new XPathExprCompiler();
            Node byteCodeNodeSet = compiler.compile(targetAttrs[i], xpath, gudElement.getOwnerDocument());
            gudElement.appendChild(byteCodeNodeSet);
            gudElement.removeAttribute(targetAttrs[i]);
        }
    }
}

