/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform.xpath;

import jp.haw.grain.xpath.XPathByteCodeElement;
import jp.haw.grain.xpath.compiler.ASTAbbreviatedStep;
import jp.haw.grain.xpath.compiler.ASTAbsoluteLocationPath;
import jp.haw.grain.xpath.compiler.ASTAndExpr;
import jp.haw.grain.xpath.compiler.ASTAxisSpecifier;
import jp.haw.grain.xpath.compiler.ASTDivExpr;
import jp.haw.grain.xpath.compiler.ASTEqualExpr;
import jp.haw.grain.xpath.compiler.ASTFunctionCall;
import jp.haw.grain.xpath.compiler.ASTFunctionExpr;
import jp.haw.grain.xpath.compiler.ASTFunctionName;
import jp.haw.grain.xpath.compiler.ASTGeExpr;
import jp.haw.grain.xpath.compiler.ASTGtExpr;
import jp.haw.grain.xpath.compiler.ASTLeExpr;
import jp.haw.grain.xpath.compiler.ASTLiteral;
import jp.haw.grain.xpath.compiler.ASTLtExpr;
import jp.haw.grain.xpath.compiler.ASTMinusExpr;
import jp.haw.grain.xpath.compiler.ASTModExpr;
import jp.haw.grain.xpath.compiler.ASTMulExpr;
import jp.haw.grain.xpath.compiler.ASTNegExpr;
import jp.haw.grain.xpath.compiler.ASTNodePI;
import jp.haw.grain.xpath.compiler.ASTNodeType;
import jp.haw.grain.xpath.compiler.ASTNotEqualExpr;
import jp.haw.grain.xpath.compiler.ASTNumber;
import jp.haw.grain.xpath.compiler.ASTOrExpr;
import jp.haw.grain.xpath.compiler.ASTPlusExpr;
import jp.haw.grain.xpath.compiler.ASTPredicate;
import jp.haw.grain.xpath.compiler.ASTQName;
import jp.haw.grain.xpath.compiler.ASTRelativeLocationPath;
import jp.haw.grain.xpath.compiler.ASTSlashExpr;
import jp.haw.grain.xpath.compiler.ASTStep;
import jp.haw.grain.xpath.compiler.ASTUnionExpr;
import jp.haw.grain.xpath.compiler.ASTVariableReference;
import jp.haw.grain.xpath.compiler.ASTXPathExpression;
import jp.haw.grain.xpath.compiler.SimpleNode;
import jp.haw.grain.xpath.compiler.XPathParserVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GudXPathVisitor
implements XPathParserVisitor {
    protected Document ownerDoc;

    public GudXPathVisitor(Document doc) {
        this.ownerDoc = doc;
    }

    protected Node rootElement(Node e) {
        Node parent = e.getParentNode();
        if (parent == null) {
            return e;
        }
        return this.rootElement(parent);
    }

    public Object visit(ASTXPathExpression node, Object data) {
        if (node.jjtGetNumChildren() > 1) {
            throw new RuntimeException("to many children!");
        }
        Element element = (Element)node.jjtGetChild(0).jjtAccept(this, data);
        return this.rootElement(element);
    }

    public Object visit(ASTAbsoluteLocationPath node, Object data) {
        if (node.jjtGetNumChildren() > 1) {
            throw new RuntimeException("to many children!");
        }
        XPathByteCodeElement absoluteAxis = XPathByteCodeElement.createAxisElement("absolute", this.ownerDoc);
        XPathByteCodeElement ctxn = XPathByteCodeElement.createContextLoadElement(this.ownerDoc);
        XPathByteCodeElement step = XPathByteCodeElement.createStepElement(this.ownerDoc);
        step.setAttribute("_0", "");
        step.setAttribute("_1", "");
        step.appendChild(absoluteAxis);
        step.appendChild(ctxn);
        Element child = null;
        if (node.jjtGetNumChildren() != 0) {
            child = (Element)node.jjtGetChild(0).jjtAccept(this, data);
        }
        if (node.getToken().kind == 13) {
            Element slashSlash = this.slashSlashExpr(data);
            slashSlash.appendChild(step);
            if (child != null) {
                child.appendChild(slashSlash);
            }
        } else if (child != null) {
            child.appendChild(step);
        }
        return ctxn;
    }

    public Object visit(ASTRelativeLocationPath node, Object data) {
        if (node.jjtGetNumChildren() > 1) {
            throw new RuntimeException("to many children!");
        }
        Element child = (Element)node.jjtGetChild(0).jjtAccept(this, data);
        XPathByteCodeElement ctxn = XPathByteCodeElement.createContextLoadElement(this.ownerDoc);
        child.appendChild(ctxn);
        return child;
    }

    public Object visit(ASTAbbreviatedStep node, Object data) {
        XPathByteCodeElement step = XPathByteCodeElement.createStepElement(this.ownerDoc);
        XPathByteCodeElement axis = XPathByteCodeElement.createAxisElement("self", this.ownerDoc);
        if (node.getToken().kind == 15) {
            axis = XPathByteCodeElement.createAxisElement("parent", this.ownerDoc);
        }
        step.setAttribute("_0", "");
        step.setAttribute("_1", "");
        step.appendChild(axis);
        return step;
    }

    public Object visit(ASTSlashExpr node, Object data) {
        if (node.jjtGetNumChildren() < 2) {
            throw new RuntimeException("not enogh children.");
        }
        Element rightNode = (Element)node.jjtGetChild(1).jjtAccept(this, data);
        Element leftNode = (Element)node.jjtGetChild(0).jjtAccept(this, data);
        if (node.getToken().kind == 13) {
            Element slashSlash = this.slashSlashExpr(data);
            rightNode.appendChild(slashSlash);
            if (((SimpleNode)node.jjtGetChild((int)0)).id == 3) {
                Element leftParent = (Element)this.rootElement(leftNode);
                slashSlash.appendChild(leftParent);
                return leftNode;
            }
            slashSlash.appendChild(leftNode);
            return leftNode;
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 3) {
            Element leftParent = (Element)this.rootElement(leftNode);
            rightNode.appendChild(leftParent);
            return leftNode;
        }
        rightNode.appendChild(leftNode);
        return leftNode;
    }

    public Object visit(ASTStep node, Object data) {
        if (node.jjtGetNumChildren() < 1) {
            throw new RuntimeException("not enogh children.");
        }
        if (node.jjtGetNumChildren() == 1) {
            return node.jjtGetChild(0).jjtAccept(this, data);
        }
        Element axis = (Element)node.jjtGetChild(0).jjtAccept(this, data);
        Element step = (Element)node.jjtGetChild(1).jjtAccept(this, data);
        Element previousPredicate = null;
        Node topPredicate = null;
        for (int i = 2; i < node.jjtGetNumChildren(); ++i) {
            Element predicate = (Element)node.jjtGetChild(i).jjtAccept(this, data);
            if (previousPredicate != null) {
                predicate.appendChild(previousPredicate);
            }
            if (topPredicate == null) {
                topPredicate = predicate;
            }
            previousPredicate = predicate;
        }
        if (axis != null) {
            step.appendChild(axis);
        }
        if (topPredicate != null) {
            topPredicate.appendChild(step);
        }
        return step;
    }

    public Object visit(ASTAxisSpecifier node, Object data) {
        if (node.getToken() == null) {
            return XPathByteCodeElement.createAxisElement("child", this.ownerDoc);
        }
        if (node.getToken().kind == 1) {
            return XPathByteCodeElement.createAxisElement("attribute", this.ownerDoc);
        }
        return XPathByteCodeElement.createAxisElement(node.getToken().image, this.ownerDoc);
    }

    public Object visit(ASTNodeType node, Object data) {
        XPathByteCodeElement step = XPathByteCodeElement.createStepElement(this.ownerDoc);
        step.setAttribute("_0", "");
        step.setAttribute("_1", node.getToken().image.equals("node") ? "" : node.getToken().image);
        return step;
    }

    public Object visit(ASTNodePI node, Object data) {
        return null;
    }

    public Object visit(ASTQName node, Object data) {
        XPathByteCodeElement step = XPathByteCodeElement.createStepElement(this.ownerDoc);
        String prefix = "";
        if (node.getPrefix() != null) {
            prefix = node.getPrefix().image;
        }
        step.setAttribute("_0", "");
        step.setAttribute("_1", "");
        if (node.getLocal().kind != 10) {
            step.setAttribute("_0", node.getLocal().image);
        }
        return step;
    }

    public Object visit(ASTPredicate node, Object data) {
        if (node.jjtGetNumChildren() > 1) {
            throw new RuntimeException("to many children!");
        }
        Element children = null;
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 12) {
            Element num = (Element)node.jjtGetChild(0).jjtAccept(this, data);
            XPathByteCodeElement nfilter = XPathByteCodeElement.createNFilterElement(this.ownerDoc);
            nfilter.appendChild(num);
            return nfilter;
        }
        if (((SimpleNode)node.jjtGetChild((int)0)).id == 21) {
            SimpleNode left = (SimpleNode)node.jjtGetChild(0).jjtGetChild(0);
            SimpleNode right = (SimpleNode)node.jjtGetChild(0).jjtGetChild(1);
            if (left.id == 14 && right.id == 12) {
                String functionName = (String)left.jjtGetChild(0).jjtAccept(this, data);
                if (functionName.equals("position")) {
                    Element num = (Element)right.jjtAccept(this, data);
                    XPathByteCodeElement nfilter = XPathByteCodeElement.createNFilterElement(this.ownerDoc);
                    nfilter.appendChild(num);
                    return nfilter;
                }
            } else if (right.id == 14 && left.id == 12) {
                String functionName = (String)right.jjtGetChild(0).jjtAccept(this, data);
                if (functionName.equals("position")) {
                    Element num = (Element)left.jjtAccept(this, data);
                    XPathByteCodeElement nfilter = XPathByteCodeElement.createNFilterElement(this.ownerDoc);
                    nfilter.appendChild(num);
                    return nfilter;
                }
            } else {
                children = (Element)node.jjtGetChild(0).jjtAccept(this, data);
            }
        } else {
            children = (Element)node.jjtGetChild(0).jjtAccept(this, data);
        }
        XPathByteCodeElement filter = XPathByteCodeElement.createFilterElement(this.ownerDoc);
        XPathByteCodeElement pushclosure = XPathByteCodeElement.createPredicateElement(this.ownerDoc);
        filter.appendChild(pushclosure);
        pushclosure.appendChild(children);
        return filter;
    }

    public Object visit(ASTFunctionCall node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        String funcName = (String)node.jjtGetChild(0).jjtAccept(this, data);
        SimpleNode funcExpr = (SimpleNode)node.jjtGetChild(1);
        if (funcName.equals("position")) {
            XPathByteCodeElement ctxpl = XPathByteCodeElement.createContextParamLoadElement(1, this.ownerDoc);
            return ctxpl;
        }
        if (funcName.equals("last")) {
            XPathByteCodeElement ctxpl = XPathByteCodeElement.createContextParamLoadElement(0, this.ownerDoc);
            return ctxpl;
        }
        XPathByteCodeElement fcall = XPathByteCodeElement.createFcallElement(this.ownerDoc);
        fcall.setAttribute("_0", funcName);
        fcall.setAttribute("_1", String.valueOf(funcExpr.jjtGetNumChildren()));
        for (int i = 0; i < funcExpr.jjtGetNumChildren(); ++i) {
            Element expr = (Element)funcExpr.jjtGetChild(i).jjtAccept(this, data);
            fcall.appendChild(this.rootElement(expr));
        }
        return fcall;
    }

    public Object visit(ASTFunctionName node, Object data) {
        String name = "";
        if (node.getPrefix() != null) {
            name = node.getPrefix().image + ":";
        }
        return name + node.getLocal().image;
    }

    public Object visit(ASTFunctionExpr node, Object data) {
        return null;
    }

    public Object visit(ASTAndExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement and = XPathByteCodeElement.createAndElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        and.appendChild(leftNode);
        and.appendChild(rightNode);
        return and;
    }

    public Object visit(ASTDivExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement div = XPathByteCodeElement.createDivElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        div.appendChild(leftNode);
        div.appendChild(rightNode);
        return div;
    }

    public Object visit(ASTEqualExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement equal = XPathByteCodeElement.createEqElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        equal.appendChild(leftNode);
        equal.appendChild(rightNode);
        return equal;
    }

    public Object visit(ASTGeExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement ge = XPathByteCodeElement.createGeElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        ge.appendChild(leftNode);
        ge.appendChild(rightNode);
        return ge;
    }

    public Object visit(ASTGtExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement gt = XPathByteCodeElement.createGtElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        gt.appendChild(leftNode);
        gt.appendChild(rightNode);
        return gt;
    }

    public Object visit(ASTLeExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement le = XPathByteCodeElement.createLeElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        le.appendChild(leftNode);
        le.appendChild(rightNode);
        return le;
    }

    public Object visit(ASTLtExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement lt = XPathByteCodeElement.createLtElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        lt.appendChild(leftNode);
        lt.appendChild(rightNode);
        return lt;
    }

    public Object visit(ASTMinusExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement sub = XPathByteCodeElement.createSubElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        sub.appendChild(leftNode);
        sub.appendChild(rightNode);
        return sub;
    }

    public Object visit(ASTMulExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement mult = XPathByteCodeElement.createMultElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        mult.appendChild(leftNode);
        mult.appendChild(rightNode);
        return mult;
    }

    public Object visit(ASTModExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement mod = XPathByteCodeElement.createModElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        mod.appendChild(leftNode);
        mod.appendChild(rightNode);
        return mod;
    }

    public Object visit(ASTNotEqualExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement notEqual = XPathByteCodeElement.createNeElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        notEqual.appendChild(leftNode);
        notEqual.appendChild(rightNode);
        return notEqual;
    }

    public Object visit(ASTOrExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement or = XPathByteCodeElement.createOrElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        or.appendChild(leftNode);
        or.appendChild(rightNode);
        return or;
    }

    public Object visit(ASTPlusExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement add = XPathByteCodeElement.createAddElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        add.appendChild(leftNode);
        add.appendChild(rightNode);
        return add;
    }

    public Object visit(ASTUnionExpr node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new RuntimeException("not enogh children.");
        }
        XPathByteCodeElement union = XPathByteCodeElement.createUnionElement(this.ownerDoc);
        Element leftNode = (Element)this.rootElement((Node)node.jjtGetChild(0).jjtAccept(this, data));
        Element rightNode = (Element)this.rootElement((Node)node.jjtGetChild(1).jjtAccept(this, data));
        union.appendChild(leftNode);
        union.appendChild(rightNode);
        return union;
    }

    public Object visit(ASTLiteral node, Object data) {
        String literal = node.getToken().image;
        if (literal.indexOf(39) != -1) {
            literal = literal.replaceAll("'", "");
        }
        if (literal.indexOf(34) != -1) {
            literal = literal.replaceAll("\"", "");
        }
        return XPathByteCodeElement.createStringValueElement(literal, this.ownerDoc);
    }

    public Object visit(ASTNumber node, Object data) {
        return XPathByteCodeElement.createNumValueElement(Integer.parseInt(node.getToken().image), this.ownerDoc);
    }

    public Object visit(ASTNegExpr node, Object data) {
        if (node.jjtGetNumChildren() != 1) {
            throw new RuntimeException("not enogh children.");
        }
        SimpleNode child = (SimpleNode)node.jjtGetChild(0);
        int count = 1;
        while (child.id == 32) {
            ++count;
            child = (SimpleNode)child.jjtGetChild(0);
        }
        if (count % 2 == 1) {
            XPathByteCodeElement neg = XPathByteCodeElement.createNegElement(this.ownerDoc);
            Element childExpr = (Element)child.jjtAccept(this, data);
            neg.appendChild(childExpr);
            return neg;
        }
        return child.jjtAccept(this, data);
    }

    public Object visit(ASTVariableReference node, Object data) {
        return null;
    }

    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    protected Element slashSlashExpr(Object data) {
        XPathByteCodeElement step = XPathByteCodeElement.createStepElement(this.ownerDoc);
        XPathByteCodeElement axis = XPathByteCodeElement.createAxisElement("descendant-or-self", this.ownerDoc);
        step.setAttribute("_0", "");
        step.setAttribute("_1", "node");
        step.appendChild(axis);
        return step;
    }

    protected void showNode(SimpleNode node) {
        System.out.print(node.toString(""));
        if (node.getToken() != null) {
            System.out.println("[token: " + node.getToken().image + "]");
        } else {
            System.out.println("");
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, null);
        }
    }
}

