package jp.haw.grain.divide;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;

/**
 * Mp̃tH_[NXłB
 * <code>DividedData</code>𐏎ǉ邱Ƃ̂łtH_[łB
 * <code>DividedData</code>̒ǉ͕sł肠܂B
 * ŌtoByteArray()\bhŕԂf[^
 * <code>DividedData</code>noɃ\[gꌋꂽbytezƂȂ܂B
 * 
 * @author nakajo
 */
public class ReadFolder implements DataFolder, Serializable {
	private static final Logger log = Logger.getLogger(ReadFolder.class);

	protected int mode;
	protected String sessionId;
	protected int index;
	protected long createTime;
	protected long survivalTime;
	protected DividedData[] dataList;
	protected String contentType;

	public ReadFolder(String sessionId, int maxCount) {
		this(sessionId, maxCount, null);
	}

	public ReadFolder(String sessionId, int maxCount, String contentType) {
		this.sessionId = sessionId;
		this.dataList = new DividedData[maxCount];
		this.mode = DataFolder.MODE_READ;
		this.createTime = Calendar.getInstance().getTimeInMillis();
		this.survivalTime = 60 * 30 * 1000; //ftHg30
		this.index = 0;
		
		if(contentType == null) {
			this.contentType = "plain/text";
		}
		
	}
	
	public DividedData getDataAt(int no) {
		for(int i=0; i<dataList.length; i++) {
			if(dataList[i].getNo() == no) return dataList[i];
		}
		
		return null;
	}

	/**
	 * f[^ǉ܂B
	 * ǉ<code>DividedData</code>NoƓf[^łɂ̃tH_ɑ݂Ăꍇ
	 * Vǉ悤ƂĂf[^ŏ㏑܂B
	 * @param data
	 * @exception ArrayIndexOutOfBoundsException Ɏw肵maxlȏ̃f[^ǉ悤ƂƂ
	 */
	public void addData(DividedData data) {
		log.debug("addDivideData: length="+data.getData().length);
		for(int i=0; i<this.dataList.length; i++) {
			if(this.dataList[i] != null && this.dataList[i].getNo() == data.getNo()) {
				this.dataList[i] = data;
				return;
			}
		}
		
		this.dataList[this.index] = data;
		this.index++;
		
		log.debug("addData: END");
	}
	
	/**
	 * ̃tH_[ێĂ<code>DividedData</code>̔zԂ܂B
	 * ̔z̓tH_[̃RXgN^Őꂽ̂łB
	 * ̂߁Azɂnull݂\܂B
	 * ܂AŕԂz<code>DividedData</code>͒ǉꂽ̂܂܂łB
	 * ̃tH_[ێĂNoɐ񂳂ꂽf[^擾ꍇ
	 * toByteArray\bhĂяoĂB
	 */
	public DividedData[] getDataList() {
		return this.dataList;
	}

	public int getMaxCount() {
		return this.dataList.length;
	}

	public int getMode() {
		return this.mode;
	}

	public String getSessionId() {
		return this.sessionId;
	}

	/**
	 * ̃tH_ɓĂ鑍Ẵf[^bytezɂĕԂ܂B
	 * Ԃbytez̓f[^ǉԂƂ͊֌WȂA<code>DividedData</code>no
	 * \[gꌋꂽbytezɂȂ܂B
	 * @return
	 * @throws IOException
	 */
	public byte[] toByteArray() throws IOException {
		
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		List sortedData = Arrays.asList(dataList);
		Collections.sort(sortedData);
		
		Iterator ite = sortedData.iterator();
		while(ite.hasNext()) {
			DividedData dData = (DividedData)ite.next();
			out.write(dData.getData());
		}
		out.close();
		return out.toByteArray();
	}
	
	
	/**
	 * ̃f[^tH_[܂Ă邩ǂԂ܂B
	 */
	public boolean isSurvival() {
		long nowTime = Calendar.getInstance().getTimeInMillis();
		return nowTime <= (this.createTime + this.survivalTime);
	}

	/**
	 * ̃tH_Ă̎~bŎw肵܂B
	 * @param l
	 */
	public void setSurvivalTime(long l) {
		survivalTime = l;
	}

	/**
	 * @return
	 */
	public long getSurvivalTime() {
		return survivalTime;
	}

	/* ( Javadoc)
	 * @see jp.haw.grain.divide.DataFolder#getContentType()
	 */
	public String getContentType() {
		return this.contentType;
	}

}
