package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.TransformOperation;

import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * @author nakajo
 */
public abstract class AbstractTransformer implements Transformer {

	protected Node node;
	protected Transformer next;
	protected GudBuilder builder;
	protected Element current;
	
	public AbstractTransformer(GudBuilder builder) {
		this.builder = builder;
	}
	
	public void apply(Node node, TransformOperation operation) {
		//ϊΏۂ̃m[h`FbN
		//ϊΏۂłȂ΁AtransformerɓnB
		if(!isTarget(node)) {
			if(next != null) next.apply(node, operation);
			return;
		}

		//ϊΏۂȂ̂ŁAnodeo^operationsB
		this.node = node;
		operation.operation(this);
	}

	/**
	 * w肳ꂽm[hϊΏۂǂԂ܂B
	 * @param node
	 * @return
	 */
	protected abstract boolean isTarget(Node node);
	
	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#transform(org.w3c.dom.Node)
	 */
	public abstract DocumentFragment transform();

	/**
	 * qvfϊꍇɂ̐eƂȂׂvfԂ܂B
	 * @return
	 */
	public abstract Element getCurrentElement();
	
	/**
	 * ɑΏۂƂȂTransformerݒ肵܂B
	 * @param t
	 */
	public void setNext(Transformer t) {
		this.next = t;
	}
	
	/**
	 * TransformerԂ܂B
	 * @return
	 */
	public Transformer getNext() {
		return this.next;
	}
}
