package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.TargetNode;
import jp.haw.grain.transform.util.Util;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/**
 * xformstriggersubmit̎qvfgud̗vfƂnamespaceȊORs[܂B
 * @author nakajo
 */
public class TriggerAndSubmitChildCopy extends AbstractTransformer {
	
	public TriggerAndSubmitChildCopy(GudBuilder builder) {
		super(builder);
	}
	
	public Element getCurrentElement() {
		return this.current;
	}

	protected boolean isTarget(Node node) {
		
		TargetNode xformsTriggerTarget = new TargetNode(GudBuilder.XFORMS_NS, "trigger", Node.ELEMENT_NODE);
		TargetNode xformsSubmitTarget = new TargetNode(GudBuilder.XFORMS_NS, "submit", Node.ELEMENT_NODE);
		
		//etriggervf邩ׂB
		//ȂΑΏۊO
		return Util.parentNodeAs(node, xformsTriggerTarget) || Util.parentNodeAs(node, xformsSubmitTarget);
	}

	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();
		if(this.node.getNodeType() == Node.ELEMENT_NODE)
			return elementTransform(dom);
			
		if(this.node.getNodeType() == Node.TEXT_NODE)
			return textTransform(dom);
			
		return null;
	}

	protected DocumentFragment elementTransform(Document dom) {
		DocumentFragment df = dom.createDocumentFragment();

		Element any = (Element)node;
		Element gud = null;
		if(any.getNamespaceURI() != null && any.getNamespaceURI() != GudBuilder.XFORMS_NS) {
			gud = dom.createElementNS(any.getNamespaceURI(), node.getLocalName());
			gud.setPrefix(any.getPrefix());
		} else if(any.getNamespaceURI() == null){
			gud = dom.createElementNS("", node.getLocalName());
		} else {
			gud = dom.createElementNS(GudBuilder.GUD_NS, node.getLocalName());
		}
		
		Util.copyAttributes(any, gud);
		/*
		try {
			Util.compileNodeBinding(gud, new String[]{"ref"});
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
		*/
		
		df.appendChild(gud);
		this.current = gud;
		
		return df;
	}
	
	protected DocumentFragment textTransform(Document dom) {
		DocumentFragment df = dom.createDocumentFragment();
		Text gud = dom.createTextNode(Util.normalizedString(this.node.getNodeValue()));
		
		df.appendChild(gud);
		this.current = null;
		
		return df;
	}

}
