/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2004/12/17
 *
 */
package jp.grain.sprout.ui;

import java.io.IOException;

import javax.microedition.io.Connection;

import jp.grain.sprout.DataHandler;
import jp.grain.sprout.Initializer;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.ValidationList;
import jp.grain.sprout.model.Instance;
import jp.grain.sprout.model.Submission;


/**
 * tH[̕\
 * 
 * @version $Id: FormView.java 46 2005-11-20 03:41:49Z goking $
 * @author Go Takahashi
 */
public interface FormContext{
    
    public static final int SEL_NONE = -1;
    public static final int SEL_SELECT = 0;
    public static final int SEL_IME_COMMIT = 2;
    public static final int SEL_IME_CANCEL = 3;
    public static final int SEL_DOWN = 4;
    public static final int SEL_UP = 5;
    public static final int SEL_RIGHT = 6;
    public static final int SEL_LEFT = 7;
    public static final int SEL_CANCEL = 8;
    
    public static final int ACT_PRESSED = 0;
    public static final int ACT_RELEASED = 1;
    public static final int ACT_IME_RESULT = 2;
    public static final int ACT_FOCUS_IN = 3;
    public static final int ACT_FOCUS_OUT = 4;

    public static final String IME_SCRIPT_LATIN = "latin";
    public static final String IME_SCRIPT_HIRAGANA = "hiragana";
    public static final String IME_SCRIPT_DIGITS = "digits";
    
    int getWidth();
    int getHeight();
	void render();
	void refresh();
    void setForm(Form form);
    Form getForm();
    /**
     * @param bindingSimpleContent
     * @param inputMode
     * @param b
     * @return
     */
    void launchIME(String text, String inputMode, boolean secret);
    String getIMEText();
    byte[] getCameraData();
    void launchCodeReader();
    void launchCameraDevice();
    
    SerializeOperation createSubmissionOperation(String url);
    SerializeOperation createSubmissionOperation(Submission submission);
    SerializeOperation createExternalInstanceLoadOperation(Instance element);
    SerializeOperation createDataLoadOperation(String url, DataHandler handler);
    
    
    /**
     * @param i
     * @param j
     * @param width
     * @param height
     */
//    void setClipRect(int x, int y, int width, int height);
//    void restoreClipRect(DrawContext context);
    /**
     * @return
     */
    
    void moveTo(int absoluteX, int absoluteY, int boxHeight);
    /**
     * 
     */
    void requestRender();
    void requestRefresh();
    void init() throws IOException;
    void execute(SerializeOperation operation);
    /**
     * @param initializer
     */
    void setInitializer(Initializer initializer);
    /**
     * @param op
     * @return
     */
    Connection createConnection(SerializeOperation op) throws IOException;

    public void formInitStart(boolean bool);

	public void showMessageDialog(String msg);
    public void showErrorDialog(String msg, Throwable t);
    public void showWarningDialog(String title, ValidationList list);
    /**
     * @param error_unexpected 
     * @param e
     */
    void notifyInitializeError(int error_unexpected, Exception e);
    
}
